package net.returnvoid.io;

import processing.core.PImage;

/*
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

/**
 * An interface to build observers which want to be informed with an image.
 * 
 * @author Diana Lange
 *
 */
public interface ImageUpdateObserver {

	/**
	 * Sets the image of this object.
	 * 
	 * @param img
	 *            An image.
	 */
	void setImage(PImage img);
}
