package net.returnvoid.io;

import net.returnvoid.color.ColorPalette;

/*
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

/**
 * An interface to build observers which want to be informed with a
 * ColorPalette.
 * 
 * @author Diana Lange
 *
 */
public interface ColorPaletteUpdateObserver {

	/**
	 * Sets the color palette of this object.
	 * 
	 * @param palette
	 *            A color palette containing colors.
	 */
	void setColorPalette(ColorPalette palette);

}
