package net.returnvoid.color;

/*
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

/**
 * A collection of valid distance measures for colors.
 * 
 * @author Diana Lange
 *
 */
public enum ColorDifferenceMeasure {
	RGBEuclidean, RGB2R4G3B, RGBMeanRed, HSBEuclidean, HSBCylinder, HSBCone, XYZEuclidean, LabDeltaE, LabDeltaE1994, LabDeltaE2000, LCHCMC, LCHEuclidean;

	/**
	 * Converts a given ColorDofferenceMeasure to its ColorSpace equivalent.
	 * E.G. RGBEuclidean will return RGBColor, LabDeltaE will return LabColor
	 * and so on.
	 * 
	 * @return The ColorSpace of the given ColorDofferenceMeasure.
	 */
	public ColorSpace toColorSpace() {

		if (this == RGBEuclidean || this == RGB2R4G3B || this == RGBMeanRed) {
			return ColorSpace.RGBColor;
		} else if (this == HSBEuclidean || this == HSBCylinder || this == HSBCone) {
			return ColorSpace.HSBColor;
		} else if (this == LabDeltaE || this == LabDeltaE2000 || this == LabDeltaE1994 || this == LCHCMC) {
			return ColorSpace.LabColor;
		} else if (this == LCHEuclidean) {
			return ColorSpace.LCHColor;
		} else {
			return ColorSpace.XYZColor;
		}
	}

	/**
	 * Checks if a ColorSpace is equal to a ColorDofferenceMeasure. They are
	 * equal if they are both members of the same color model. E.G. RGBColor
	 * will be equal to RGBMeanRed but not equal to LabDeltaE.
	 * 
	 * @param space
	 *            The ColorSpace to compare to.
	 * @return True if the space is equal.
	 */
	public boolean equals(ColorSpace space) {
		ColorSpace self = this.toColorSpace();

		return self == space;
	}
}
