package net.returnvoid.analytics;

/*
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

/**
 * An interface to build clusterings.
 * 
 * @author Diana Lange
 *
 */
public interface Clustering {

	/**
	 * Returns the loss of the clustering (= mean loss of all clusters).
	 * 
	 * @return The loss of the clustering.
	 */
	public Float getLoss();

	/**
	 * The number of clusters to this clustering. k might differ from the
	 * getClusters().length, when empty clusters (clusters with no members) are
	 * automatically removed.
	 * 
	 * @return The number of clusters.
	 */
	public int getK();

	/**
	 * Returns all clusters of this clustering.
	 * 
	 * @return The clusters.
	 */
	public Cluster[] getClusters();

	/**
	 * Returns the cluster which is the most similar to the given parameter.
	 * 
	 * @param o
	 *            An element.
	 * @return The most similar cluster to the input or null if the input is not
	 *         compatible to the data type of the cluster members.
	 */
	public Cluster getCluster(Object o);
}
