import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to check if lines intersect and how to remove lines from a set 
 * with intersecting lines to get a subset that has no longer intersections of any lines.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */
 

void setup() {
  size(1280, 720);

  noLoop();
}

void draw() {
  background(#E8EAEA);
  
  // create and store some random lines
  ArrayList<Line> lines = getRandomLines(700);

  // draw all lines (light blue lines in the background)
  strokeWeight(1);
  stroke(#8BAEBF);
  for (Line l : lines) {
    l.draw();
  }

  fill(#C158BA);
  noStroke();
  
  // iterate over all lines and check if there is an intersection with any other line
  // if an intersection is found, draw a circle at the intersection location
  for (int i = 0; i < lines.size(); i++) {
    for (int j = i + 1; j < lines.size(); j++) {
      
      // check if intersection with current line is found
      // if there is an intersection the point of intersection is returned
      // of not, null is returned
      PVector cross = Line.intersection(lines.get(i), lines.get(j));
      
      // check for intersection (no location of intersection):
      // boolean hasIntersection = Line.hasIntersection(lines.get(i), lines.get(j));
      if (cross != null) {
        // intersection found > draw circle
        ellipse(cross.x, cross.y, 6, 6);
      }
    }
  }

  // remove lines so that the resulting set of lines has no intersections
  strokeWeight(2);
  Line.removeIntersectingLines(lines);
  
  // draw lines again (black, thick lines)
  stroke(0);
  for (Line l : lines) {
    l.draw();
  }
  
}

ArrayList<Line> getRandomLines(int num) {

  ArrayList<Line> lines = new ArrayList<Line>(num);
  for (int i = 0; i < num; i++) {
    PVector p = new PVector(random(width), random(height));
    float angle = random(TWO_PI);
    float length = random(5, 100);

    lines.add(new Line(this, p, angle, length));
  } 

  return lines;
}


void mousePressed() {
  redraw();
}

void keyPressed() {
  saveFrame("screenshots/" + StringTools.timestamp() + ".png");
}