
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to create a smooth curve (from a non smooth curve).
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

// input locations for curve
PVector[] locations = {
  new PVector(256.0, 360.0), 
  new PVector(275.29517, 374.9309), 
  new PVector(292.91553, 383.44574), 
  new PVector(305.6478, 384.60806), 
  new PVector(345.498, 390.3977), 
  new PVector(380.57742, 377.29553), 
  new PVector(409.11188, 368.53128), 
  new PVector(428.14627, 358.98895), 
  new PVector(482.17096, 311.68286), 
  new PVector(497.83478, 272.0697), 
  new PVector(558.14655, 271.37122), 
  new PVector(606.2364, 263.58472), 
  new PVector(628.4595, 269.5984), 
  new PVector(676.1889, 294.54913), 
  new PVector(747.89026, 295.37195), 
  new PVector(746.5408, 282.096), 
  new PVector(750.38, 269.36017), 
  new PVector(758.76215, 256.1799), 
  new PVector(801.10236, 234.99237), 
  new PVector(834.82166, 265.4284), 
  new PVector(882.6829, 273.21674), 
  new PVector(956.72125, 272.54858), 
  new PVector(997.4523, 309.76245), 
  new PVector(1010.81726, 342.35272), 
  new PVector(1022.32825, 360.0)
};

void setup() {
  size(1280, 720);
}


void draw() {

  background(240);
  noFill();

  // create and draw original curve
  Curve curve = new Curve(this, locations);
  curve.setY(200);
  drawCurve(curve);

  // create a smoothend version of the curve that has the same number
  // of control points. The control points of smooth curves
  // have always an evenly distribution
  Curve smoothend = curve.toSmoothedCurve();
  smoothend.translate(0, 150);
  drawCurve(smoothend);

  // create a smoothend version of the curve that has less control points (0.7 x curve.size() constrol points)
  Curve smoothendLessDetails = curve.toSmoothedCurve(0.7);
  smoothendLessDetails.translate(0, 300);
  drawCurve(smoothendLessDetails);

  // create a smoothend version of the curve that has 12 control points
  // toSmoothedCurve(int) sets the number of control points
  // toSmoothedCurve(float) sets the number of control points relative to the input curve's control points
  Curve smoothend12ControlPoints = curve.toSmoothedCurve(12);
  smoothend12ControlPoints.translate(0, 450);
  drawCurve(smoothend12ControlPoints);
}

void drawCurve(Curve curve) {
  curve.draw();

  for (int i = 0; i < curve.size(); i++) {
    PVector p = curve.get(i);
    ellipse(p.x, p.y, 10, 10);
  }
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}