
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;


/**
 * This sketch demonstates how to create a Curve shape and how to calculate normals on it.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */



void setup() {
  size(1280, 720);
}

void draw() {

  background(240);
  noFill();
  stroke(0);

  // coordinates for curve
  PVector[] locations = {
    new PVector(256, 560), 
    new PVector(289, 541), 
    new PVector(327, 534), 
    new PVector(361, 553), 
    new PVector(400, 556), 
    new PVector(437, 551), 
    new PVector(476, 551), 
    new PVector(512, 562), 
    new PVector(547, 545), 
    new PVector(583, 560)
  };

  // build the curve, re-scale it and move it to target location 
  Curve curve = new Curve(this, locations);
  curve.scale(3);
  curve.setY(height * 0.5);
  curve.setX(width * 0.5 - curve.getLength() * 0.5);

  drawCurve(curve);

  // draw 100 normals along the curve
  stroke(0, 120);
  int num = 100;
  float lineLength = 100;
  for (int i = 0; i < num; i++) {

    // map index to t + i (i = index of curve point, t = relative position between this curve point and next curve point)
    float tplusi = map(i, 0, num - 1, 0, curve.size() - 1);

    // get normal informations by t (normalInfo contain [x, y, angle] of normal)
    float[] normalInfo = curve.getNormal(tplusi);

    float startX = normalInfo[0];
    float startY = normalInfo[1];
    float angle = normalInfo[2];

    // calculate start and end location of normal
    PVector start = new PVector(startX, startY);
    PVector end = RMath.polarToCartesian(start, normalInfo[2], lineLength);

    // build line and draw it
    Line normal = new Line(this, start, end);
    normal.draw();
  }
}

void drawCurve(Curve curve) {
  stroke(0);

  // draw curve
  curve.draw();


  // iterate over all control points and draw them
  for (int i = 0; i < curve.size(); i++) {
    PVector p = curve.get(i);
    ellipse(p.x, p.y, 10, 10);
  }
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}