
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;


/**
 * This sketch demonstates how to create shapes, how to transform (translate, rotate, scale) them and how to draw them.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */


void setup() {
  size(1280, 720);
}


void draw() {

  background(240);

  // create shapes
  float padd = width * 0.1;
  float x = padd;
  float y = 50;
  float w = width * 0.3333 - padd * 2;
  float h = w * 0.667;
  Line line1 = new Line(this, x, y, x + w, y);

  x = width * 0.3333 + padd;
  Rect rect1 = new Rect(this, x, y, w, h);

  x = 2 * width * 0.3333 + padd;
  x += w * 0.5;
  y += h * 0.5;
  Ellipse ellipse1 = new Ellipse(this, x, y, w, h);

  // draw shapes - first row
  fill(255);
  stroke(0);
  line1.draw(); 
  rect1.draw();
  ellipse1.draw();

  // get copies of shapes and store them under new names
  Line line2 = line1.copy();
  Rect rect2 = rect1.copy();
  Ellipse ellipse2 = ellipse1.copy();
  Line line3 = line1.copy();
  Rect rect3 = rect1.copy();
  Ellipse ellipse3 = ellipse1.copy();

  // angle of rotation for shapes
  float rotation = map(mouseX, 0, width, -PI / 2, PI / 2);

  // translate shapes to new location (200 is added to y-location of shape)
  line2.translate(0, 200);
  rect2.translate(0, 200);
  ellipse2.translate(0, 200);
  line3.translate(0, 200);
  rect3.translate(0, 200);
  ellipse3.translate(0, 200);

  // draw tanslated shapes - second row
  fill(255);
  line2.draw(); 
  rect2.draw();
  ellipse2.draw();

  // scale and rotate first copy shapes
  // when no additional parameter is give, the shapes are
  // transformed to their first control point (e.g. start coordinate of line, 
  // coordinate of top left corner in rectangle, ...)
  line2.scale(0.8);
  rect2.scale(0.8);
  ellipse2.scale(0.8);
  line2.rotate(rotation);
  rect2.rotate(rotation);
  ellipse2.rotate(rotation);

  // scale and rotate second copy shapes
  // the transformation can be done relative to a certain coordinate
  // in this case, this coordinate is the center location of the shape
  line3.scale(line3.getCenter(), 0.8);
  rect3.scale(rect3.getCenter(), 0.8);
  ellipse3.scale(ellipse3.getCenter(), 0.8);
  line3.rotate(line3.getCenter(), rotation);
  rect3.rotate(rect3.getCenter(), rotation); 
  ellipse3.rotate(ellipse3.getCenter(), rotation);

  // draw rotated, scaled shapes again - second row

  // blue shapes > transformation relative to first control point of shape
  noFill();
  stroke(15, 150, 180);
  line2.draw(); 
  rect2.draw();
  ellipse2.draw();

  // magenta shapes > transformation relative to center of shape
  stroke(220, 20, 170);
  line3.draw(); 
  rect3.draw();
  ellipse3.draw();

  // get new copy shapes
  Line line4 = line1.copy();
  Rect rect4 = rect1.copy();
  Ellipse ellipse4 = ellipse1.copy();

  // translate them by setting a certain coordinate
  line4.setY(500);
  rect4.setY(500);
  ellipse4.setY(500);

  // draw translated copy shapes
  stroke(0);
  fill(255);
  line4.draw(); 
  rect4.draw();
  ellipse4.draw();

  // set rotation and dimension (length / width / height) of shapes
  line4.setLength(100);
  line4.setRotation(line4.getCenter(), PI / 4);
  rect4.setWidth(200);
  rect4.setHeight(200);
  rect4.setRotation(rect4.getCenter(), PI / 4);
  ellipse4.setWidth(200);
  ellipse4.setHeight(200);
  ellipse4.setRotation(ellipse4.getCenter(), PI / 4);

  // draw transformed shapes
  noFill();
  line4.draw(); 
  rect4.draw();
  ellipse4.draw();
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}