
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;


/**
 * This sketch demonstates how to convert shape to other shapes.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */


void setup() {
  size(1280, 720);
}


void draw() {

  background(240);
  stroke(30, 100, 130);
  strokeWeight(4);
  fill(20, 170, 200);



  // create an initial rectangle

  float rectX = 50;
  float rectY = 190;
  float rectWidth = 250;
  float rectHeight = 300;
  Rect rect = new Rect(this, rectX, rectY, rectWidth, rectHeight);
  rect.draw();

  // convert rectangle to line segments
  LineSegments seg = rect.toLineSegments();

  // translate the line segments to new location and change the position of each control point slightly
  // since the base shape was a rectangle the created line segments has 5 control points
  seg.translate(425, 0);

  PVector p0 = seg.get(0);
  PVector p1 = seg.get(1);
  PVector p2 = seg.get(2);
  PVector p3 = seg.get(3);
  PVector p4 = seg.get(4);

  seg.set(0, p0.x - 10, p0.y - 50);
  seg.set(1, p1.x + 50, p1.y + 70);
  seg.set(2, p2.x - 30, p2.y - 20);
  seg.set(3, p3.x + 10, p3.y + 50);
  seg.set(4, p4.x, p4.y + 100);

  seg.draw();


  // convert the line segments to a curve (and translate it)
  Curve curve = seg.toCurve();
  curve.translate(425, 0);

  curve.draw();
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}