
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;


/**
 * This sketch demonstates how to get the bounding box of a shape.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */
 
RShape[] shapes;

void setup() {
  size(1280, 720);
  shapes = new RShape[3];
  
  
  // create shapes
  float padd = width * 0.05;
  float x = padd;
  float w = width * 0.3333 - padd * 2;
  shapes[0] = new Line(this, x, height * 0.5, x + w, height * 0.5);
  
  x = width * 0.3333 + padd;
  shapes[1] = new Rect(this, x, height * 0.5 - w * 0.667 * 0.5, w, w * 0.667);
  
  x = 2 * width * 0.3333 + padd;
  
  shapes[2] = new Ellipse(this, x + w * 0.5, height * 0.5, w, w * 0.667);
  frameRate(30);
}


void draw() {

  background(240);
  
  // iterate over all shapes
  for (int i = 0; i < shapes.length; i++) {
    
    // get current shape and its center
    RShape shape = shapes[i];
    PVector center = shape.getCenter();
    
    // roate the shape around that center
    shape.rotate(center, PI * 0.02);
    
    // draw shape
    fill(255);
    shape.draw();
    
    // get the bounding box and draw it
    Rect boundingBox = shape.getBoundingBox();
    noFill();
    boundingBox.draw();
  }
  
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}