import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to use an observer interface.
 * Observers are instances of classes, which are informed whenever
 * there is a change of state in the observed object. In the case
 * of images, the ImageLoader instance is observed 
 * (i.e. the change of the currently loaded image) and the
 * instance of the example class 'ImageDrawer' will be informed 
 * about any changes by calling the 'setImage(PImage)'
 * method.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader loader;
ImageDrawer drawer;

void setup() {
  size(1280, 720);

  // create a new ImageLoader, all palettes from subfolder 'data'
  // will be loaded. a new color palette from that folder will be 
  // loaded when clicking the mouse
  loader = new ImageLoader(this);
  loader.disableKeys();

  // create the instance, which should listen to changes of the loader.
  drawer = new ImageDrawer();

  // add the instance 'drawer' to the loader (you can only add 
  // instances of classes that implement the ImageUpdateObserver 
  // interface). now setImage(PImage) of 'drawer' will be called 
  // every time a image of the loader is loaded.
  loader.addObserver(drawer);

  textFont(createFont("Arial", 16));
  frameRate(30);
}

void draw() {

  background(255);
  drawer.display();
}

void mousePressed() {
  loader.next();
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}