// a class that implements ImageUpdateObserver
// so it can listens to changes of the loader.
class ImageDrawer implements ImageUpdateObserver {
  PImage img = null;

  ImageDrawer() {
  }

  // all classes that implement ImageUpdateObserver must have 
  // this setImage(PImage) method.
  void setImage(PImage newImage) {
    // every time the current palette of the loader changes 
    // this method will be called.

    // store that loaded image to local attribut
    img = newImage;

    println("new image received at " + StringTools.timestamp());
  }


  void display() {
    if (img != null) {
      image(img, 0, 0);

      fill(0);
      textAlign(LEFT, BOTTOM);
      text("Press mouse for next image.", 10, height - 10);
    } else {
      fill(0);
      textAlign(CENTER, CENTER);
      text("No image loaded yet. Please press mouse.", width * 0.5, height * 0.45);
    }
  }
}