import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to use the loader to load and display
 * an image sequence.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader loader;

void setup() {
  size(250, 250);
  
  // create ImageLoader instance with source folder for images 
  loader = new ImageLoader(this, "image_sequenz");
  frameRate(30);
  textFont(createFont("Arial", 16));
}

void draw() {
 
  // draw currently loaded image
  image(loader.getCurrent(), 0, 0);
  
  // load next image for next frame
  loader.next();
  
  // show file name of currently loaded image
  fill(255);
  text(loader.getFileName(), 10, height - 10);
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}