import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to enable / disable the key settings
 * and how to control the loading of files manually.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader loader;

void setup() {
  size(1280, 720);

  /*
   * create ImageLoader instance. all images found in sub-foulder "data" can be loaded
   * with this loader. One image is loaded at a time. To get a new image from that sub-folder you 
   * can use the default controls.
   *
   * Default controls for loader:
   * Arrow right = next image
   * Arrow left = previous image
   * Arrow top = first image in directory
   * Arrow bottom = last image in directory
   * Tab = next random image from directory
   */

  loader = new ImageLoader(this);

  // disable all key events for the loader
  // to get the files of the loader the next() / previous() / ... 
  // methods have to be called manually (sey keyPressed()).
  loader.disableKeys();
  frameRate(30);

  textFont(createFont("Arial", 16));
}

void draw() {

  background(10);

  // get current image from loader
  PImage image = loader.getCurrent();

  // draw currently loaded image
  image(image, 0, 0);

  fill(255);
  text("use w/a/s/d/r to change image", 10, height - 10);
}

void keyPressed() {

  // get new images using w/a/s/d/r
  if (key == 'd') {
    loader.next();
  } else if (key == 'a') {
    loader.previous();
  } else if (key == 'w') {
    loader.first();
  } else if (key == 's') {
    loader.last();
  } else if (key == 'r') {
    loader.nextRandom();
  } else if (key == '1') {
    // disable default key settings
    loader.disableKeys();
  } else if (key == '2') {
    // enable default key settings
    loader.enableKeys();
  } else if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}