import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to use the ImageLoader and how to customize it.
 * Costumizable is:
 * - the location of the loading directory 
 * - the the key settings
 * - key events can be enabled / disabled
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader animalLoader;
ImageLoader miscLoader;

void setup() {
  size(1280, 720);

  // create two ImageLoader instances. They both should
  // listen to different key events, i.e. animalLoader can 
  // be changed without changing miscLoader

  // the second parameter sets a directory relative to the sketch
  // i.e. the folder is located at "io_ImageLoader_customized/fotos/animals/" 
  // for the first loader. Please regard that slashes must be escaped,
  // i.e. a backslash marking a sub-directory must be written with a double
  // backslash
  animalLoader = new ImageLoader(this, "fotos\\animals");
  miscLoader = new ImageLoader(this, "fotos\\other");

  // overwrite default key settings of one loader
  animalLoader.setKey("next", 'd');
  animalLoader.setKey("previous", 'a');
  animalLoader.setKey("first", 'w');
  animalLoader.setKey("last", 's');
  animalLoader.setKey("random", 'r');

  // you can reset to default key settings with:
  // animalLoader.resetKeySettings();

  // you can disable keys at all. Then you have to handle the 
  // loading of a next file by yourself:
  // animalLoader.disableKeys(); 
  // animalLoader.next();

  // you can once enable the keys again:
  // animalLoader.enableKeys();

  frameRate(30);

  textFont(createFont("Arial", 16));
}

void draw() {

  background(10);

  // get current animal image 
  PImage animal = animalLoader.getCurrent();

  // get the file name of it (true => with removed file extension)
  String animalFileName = animalLoader.getFileName(true);

  // get current misc image 
  PImage other = miscLoader.getCurrent();

  // get the file name of it (with file extension)
  String otherFileName = miscLoader.getFileName();


  // draw images and file names
  image(animal, 0, 0, animal.width * 0.5, animal.height * 0.5);
  image(other, width * 0.5, 0, other.width * 0.5, other.height * 0.5);

  fill(255);
  text(animalFileName + "\nuse w/a/s/d/r to change image", 10, height - 36);
  text(otherFileName + "\nuse arrow keys + tab to change image", width * 0.5 + 10, height - 36);
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}