import net.returnvoid.tools.*;
import net.returnvoid.io.*;

/**
 * This sketch shows how to use the ImageLoader.
 * Loaders handle the loading of specific types (e.g. images, color palettes, ...)
 * as well as the simple iteration over a couple of files of the given type.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader loader;

void setup() {
  size(1280, 720);


  /*
   * create ImageLoader instance. all images found in sub-foulder "data" can be loaded
   * with this loader. One image is loaded at a time. To get a new image from that sub-folder you 
   * can use the default controls.
   *
   * Default controls for loader:
   * Arrow right = next image
   * Arrow left = previous image
   * Arrow top = first image in directory
   * Arrow bottom = last image in directory
   * Tab = next random image from directory
   */

  loader = new ImageLoader(this);


  frameRate(30);

  textFont(createFont("Arial", 16));
}

void draw() {

  background(255);

  // get currently loaded image and its file name
  PImage image = loader.getCurrent();
  String fileName = loader.getFileName();

  // draw currently loaded image
  // use default keys to move to another image
  image(image, 0, 0);

  fill(0);
  text(fileName + " | use arrow keys + tab to change image", 10, height - 10);
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}