import net.returnvoid.tools.*;
import net.returnvoid.io.*;

/**
 * This sketch shows how to use the ImageLoader to load all 
 * images from one directory.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */
 
ImageLoader loader;

void setup() {

  size(1280, 720);

  /*
   * create ImageLoader instance. all images found in sub-foulder "data" will be loaded
   * with this loader.
   */
  loader = new ImageLoader(this);

  // this doesn't need to listen to the key events since
  // all images are loaded immediately 
  loader.disableKeys();

  frameRate(30);
  textFont(createFont("Arial", 12));
}

void draw() {

  background(0);
  noStroke();

  // Option 1: get all images buy iteration -------------------------

  // loader.size() returns the number of files (images) found in the given directory
  float w = (float) width / loader.size();
  float h = height;

  // iterate over all images
  for (int i = 0; i < loader.size(); i++) {
    float x = i * w;
    float y = 0;

    // get image from loader with index i
    PImage img = loader.get(i);

    // draw it
    image(img, x, y);
    
    // get file name of the image with index i
    // with second parameter set to true the file
    // extension is removed from the returned String
    String filename = loader.getFileName(i, true);
    
    fill(255);
    rect(x, height - 30, w, 30);
    fill(80);
    textAlign(CENTER);
    text(filename, x + w * 0.5, height - 10);
  }

  // Option 2: get all images from loader and store them in an arry -------------------------

  PImage[] images = loader.loadAllFiles();

  // iterate over array
  for (int i = 0; i < images.length; i++) {
    float x = i * w;
    float y = height * 0.5;
    PImage img = images[i];
    
    // draw image
    image(img, x, y);    
  }
  
  // draw file names -----------------------------------------------------
  
  // iterate over all images
  for (int i = 0; i < loader.size(); i++) {
    float x = i * w;
    
    // get file name of the image with index i
    // with second parameter set to true the file
    // extension is removed from the returned String
    String filename = loader.getFileName(i, true);
    
    fill(255);
    rect(x, height - 30, w, 30);
    fill(80);
    textAlign(CENTER);
    text(filename, x + w * 0.5, height - 10);
  }
  
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}