import net.returnvoid.io.*;
import net.returnvoid.color.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to use an observer interface.
 * Observers are instances of classes, which are informed whenever
 * there is a change of state in the observed object. In the case
 * of color palette, the ColorPaletteLoader instance is observed 
 * (i.e. the change of the currently loaded ColorPalette) and the
 * instance of the example class 'ColorfulCircles' will be informed 
 * about any changes by calling the 'setColorPalette(ColorPalette)'
 * method.
 * The ColorPaletteLoader works similar to the ImageLoader 
 * (but only loads .color.json files). For further informations please 
 * inspect the ImageLoader examples. For further explanations on 
 * ColorPalette please have a look at the color_ColorPalette examples.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ColorPaletteLoader loader;
ColorfulCircles circles;

void setup() {
  size(1280, 720);

  // create a new ColorPaletteLoader, all palettes from subfolder 'data'
  // will be loaded. a new color palette from that folder will be 
  // loaded when clicking the mouse
  loader = new ColorPaletteLoader(this);
  loader.disableKeys();

  // create the instance, which should listen to changes of the loader.
  circles = new ColorfulCircles(1000);

  // add the instance 'circles' to the loader (you can only add 
  // instances of classes that implement the ColorPaletteUpdateObserver 
  // interface). now setColorPalette(ColorPalette) of 'circles' will be called 
  // every time a color palette of the loader is loaded.
  loader.addObserver(circles);

  frameRate(30);
  textFont(createFont("Arial", 16));
}

void draw() {

  background(255);
  circles.display();
}

void mousePressed() {
  
  // get new color palette on mouse click
  loader.nextRandom();
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}