// a class that implements ColorPaletteUpdateObserver
// so it can listens to changes of the loader.
class ColorfulCircles implements ColorPaletteUpdateObserver {
  boolean colorsLoaded = false;
  ColoredCircle[] circles;

  ColorfulCircles(int size) {
    // init 'size' circles with random location / diameter which 
    // are all filled white
    circles = new ColoredCircle[size];
    for (int i = 0; i < circles.length; i++) {
      PVector location = new PVector(random(width), random(height));
      float diameter = random(5, 100);
      color c = color(255);

      circles[i] = new ColoredCircle(location, diameter, c);
    }
  }

  // all classes that implement ColorPaletteUpdateObserver must have 
  // this setColorPalette(ColorPalette) method.
  void setColorPalette(ColorPalette palette) {
    // every time the current palette of the loader changes 
    //  this method will be called.
    
    println("new color palette received at " + StringTools.timestamp());

    // set new colors for all members
    colorsLoaded = true;
    for (int i = 0; i < circles.length; i++) {
      color c = palette.getRandomWeighted().getColor();
      circles[i].setColor(c);
    }
  }

  void display() {
    stroke(0);
    for (int i = 0; i < circles.length; i++) {
      circles[i].display();
    }

    if (!colorsLoaded) {

      fill(0, 120);
      noStroke();
      rect(0, height * 0.5 - 50, width, 40);

      textAlign(CENTER);
      fill(255);
      text("No color palette loaded yet. Please press mouse", width * 0.5, height * 0.5 - 25);
    }
  }
}