import net.returnvoid.io.*;
import net.returnvoid.color.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to use a ColorPaletteLoader. 
 * Loaders handle the loading of specific types (e.g. images, color palettes, ...)
 * as well as the simple iteration over a couple of files of the given type.
 * The ColorPaletteLoader works similar to the ImageLoader (but only loads .color.json files).
 * For further informations please inspect the io_ImageLoader examples. For further
 * explanations on ColorPalette please have a look at the color_ColorPalette
 * examples.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

// loader that will handle the loading of color palettes
// the loader will look for files with extension ".color.json"
ColorPaletteLoader loader;

void setup() {
  size(1280, 720);

  /*
   * create ColorPaletteLoader instance. all color palettes found in sub-foulder "data" can be loaded
   * with this loader. One color palette is loaded at a time. To get a new color palette from that sub-folder you 
   * can use the default controls.
   *
   * Default controls for loader:
   * Arrow right = next color palette
   * Arrow left = previous color palette
   * Arrow top = first color palette in directory
   * Arrow bottom = last color palette in directory
   * Tab = next random color palette from directory
   */
  loader = new ColorPaletteLoader(this);

  frameRate(30);
  textFont(createFont("Arial", 16));
}

void draw() {

  background(0);
  noStroke();

  // get the current color palette and its file name
  ColorPalette palette = loader.getCurrent();
  String name = loader.getFileName();

  // draw the palette
  palette.draw(this, 0, 0, width, height);

  // draw information
  textAlign(CENTER);
  noStroke();
  fill(0, 30);
  rect(0, 0, width, 30);
  fill(255);
  text(name, width * 0.5, 20);
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}