import net.returnvoid.graphics.grid.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to create, use and change a basic grid systems.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

void setup() {
  size(1280, 720);
}

void draw() {

  background(#718F9A);

  strokeWeight(2);
  stroke(#225159);
  fill(#B9C0B8);

  // set up the dimensions and location of the grid
  float gridX = 20;
  float gridY = 20;
  float gridWidth = width * 0.5 - 30;
  float gridHeight = height * 0.5 - 30;

  // set up the number of columns and rows of the grid
  int rows = 20;
  int columns = 30;

  // build the grid > all elements will be patterned within the defined rectangular area
  TableGrid grid = GridMaker.createTable(gridX, gridY, gridWidth, gridHeight, columns, rows);

  // draw grid with basic setup (top left version) 
  drawGrid(grid);

  // ------------------------------------------------------------------------

  // change location of grid
  grid.setX(width * 0.5 + 10);

  // set padding of elements: when no parameters are given to setPadding() the 
  // padding will be equal to the dimension of the elements
  // when setting the padding the dimension of the elements will be effected

  grid.setPadding();

  // draw grid with padding at new location (top right verion)
  drawGrid(grid);


  // ------------------------------------------------------------------------

  // change location of grid
  grid.setX(20);
  grid.setY(height * 0.5 + 10);

  // change number of rows and columns
  grid.setColumns(10);
  grid.setRows(6);

  // set the padding of elements
  grid.setPaddingX(0.25);
  grid.setPaddingY(0.15);

  // draw new grid (bottom left version)
  drawGrid(grid);

  // ------------------------------------------------------------------------

  // change location
  grid.setX(width * 0.5 + 10);

  // change dimension of grid 
  grid.setWidth(width * 0.3333);
  grid.setHeight(height * 0.3333);

  // change number of elements for this grid (columns & rows will be calculated automatically)
  grid.setSize(200);

  // draw new grid (bottom right version)
  drawGrid(grid);
}

void drawGrid(RGrid grid) {

  // iterate of the elements of the grid
  for (int i = 0; i < grid.size(); i++) {

    // get location and dimension of the current element
    float x = grid.getX(i);
    float y = grid.getY(i);
    float w = grid.getWidth(i);
    float h = grid.getHeight(i);

    // draw ellipse with the given location and dimension
    ellipse(x, y, w, h);
  }
}


void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}