import net.returnvoid.graphics.grid.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to create and use spiral grid systems.
 * The difference between the two versions of spiral grids is shown:
 * - version one (SpiralGrid) has a even distribution of angles between the elements which make the elements in the center appear more dense
 * - version two (EquiSpiralGrid) has a even distribution of elements 
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

void setup() {
  size(1280, 720);
}

void draw() {

  background(#718F9A);

  strokeWeight(2);
  stroke(#225159);
  fill(#B9C0B8);

  // set up the dimensions of the grid
  float gridX = width * 0.25;
  float gridY = height * 0.5;
  float gridRadius = height * 0.4;
  
  // the spiral will rotate 5 times and the
  // elements will be separated by PI * 0.1 angle
  float gridAngle = PI * 0.1;
  float rotations = 5;

  // build and draw the grid
  // elements in the simple spiral grid will appear more dense in the center of the grid 
  SpiralGrid spiral = GridMaker.createSpiral(gridX, gridY, gridRadius, gridAngle, rotations);
  drawGrid(spiral);
  
  // build and draw second spiral with elements that are distributed evenly
  float elementSize = 20;
  gridX = width * 0.75;
  
  EquiSpiralGrid equiSpiral = GridMaker.createEquiSpiral(gridX, gridY, gridRadius, elementSize, rotations); 
  drawGrid(equiSpiral);

}

void drawGrid(RGrid grid) {

  // iterate of the elements of the grid
  for (int i = 0; i < grid.size(); i++) {

    // get location and dimension of the current element
    float x = grid.getX(i);
    float y = grid.getY(i);
    float w = grid.getWidth(i);
    float h = grid.getHeight(i);

    // draw ellipse with the given location and dimension
    ellipse(x, y, w, h);
  }
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}