import net.returnvoid.graphics.grid.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to nest grid systems to build
 * visual complex graphics.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

void setup() {
  size(1280, 720);
  noLoop();
}

void draw() {

  background(#718F9A);

  strokeWeight(1);
  stroke(#225159);
  fill(#B9C0B8);

  // set up the dimensions ad location of the grid
  float parentX = 20;
  float parentY = 20;
  float parentWidth = width - 40;
  float parentHeight = height- 40;

  // set up the number of elements for parent grid
  int parentSize = 800;

  // build the grid > all elements will be patterned within the defined rectangular area
  TableGrid parent = GridMaker.createTable(parentX, parentY, parentWidth, parentHeight, parentSize);
  
  // add some random padding to the cells
  float padding = random(0.5);
  parent.setPadding(padding);
  
  // choose randomly if children grids should have padding
  boolean childPadding = random(100) < 50;

  // iterate of the elements of the parent grid
  for (int i = 0; i < parent.size(); i++) {

    // get location and dimension of the current element
    float w = parent.getWidth(i);
    float h = parent.getHeight(i);

    float x = parent.getX(i) - w * 0.5;
    float y = parent.getY(i) - h * 0.5;

    int childSize = (int) sq((int) random(1, 6));
    TableGrid child = GridMaker.createTable(x, y, w, h, childSize);
    if (childPadding) {
      child.setPadding();
    }

    // iterate of the elements of the child grid
    for (int j = 0; j < child.size(); j++) {
      // get location and dimension of the current element
      w = child.getWidth(j);
      h = child.getHeight(j);

      x = child.getX(j) - w * 0.5;
      y = child.getY(j) - h * 0.5;

      rect(x, y, w, h);
    }
  }
}

void mousePressed() {
  redraw();
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}