import net.returnvoid.graphics.grid.*;
import net.returnvoid.graphics.shape.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to build a shape based on a grid (spiral grid to spiral curve).
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

void setup() {
  size(1280, 720);
}

void draw() {

  background(#718F9A);

  strokeWeight(2);
  

  // set up the dimensions of the grid
  float gridX = width * 0.5;
  float gridY = height * 0.5;
  float gridRadius = height * 0.4;
  
  // the spiral will rotate 'rotations' times and the
  // elements will be separated by 'gridAngle' angle
  float gridAngle = map(mouseX, 0, width, PI * 0.05, PI * 0.2);
  float rotations = map(mouseY, 0, height, 1, 20);

  // build and draw the grid
  // elements in the simple spiral grid will appear more dense in the center of the grid 
  SpiralGrid spiral = GridMaker.createSpiral(gridX, gridY, gridRadius, gridAngle, rotations);

  // get all coordinates of the spiral grid and use them to build a curve
  Curve curve = new Curve(this, spiral.getCoordinates());
  
  
  // draw curve
  stroke(#225159);
  noFill();
  curve.draw();
  
  // draw coordinates of spiral grid
  fill(#225159);
  noStroke();
  drawGrid(spiral);
}


void drawGrid(RGrid grid) {

  // iterate of the elements of the grid
  for (int i = 0; i < grid.size(); i++) {

    // get location and dimension of the current element
    float x = grid.getX(i);
    float y = grid.getY(i);
    float w = 10; 
    float h = 10;

    // draw ellipse with the given location and dimension
    ellipse(x, y, w, h);
  }
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}