import net.returnvoid.graphics.grid.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to create and use basic grid systems.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

void setup() {
  size(1280, 720);
}

void draw() {

  background(#718F9A);

  strokeWeight(2);
  stroke(#225159);
  fill(#B9C0B8);

  // set up the dimensions and location of the grid
  float gridX = width * 0.5;
  float gridY = height * 0.5;
  float gridRadius = height * 0.4;

  // set up the number of elements of this grid
  int size = 50;

  // set up position of first element
  float startAngle = map(mouseY, 0, height, 0, TWO_PI);

  // build the grid
  EllipseGrid grid = GridMaker.createEllipse(gridX, gridY, gridRadius, size);
  grid.setStartAngle(startAngle);

  // set space between elements
  grid.setPadding(0.5);

  // draw gird
  drawGrid(grid);

  // update number of elements in grid and draw again
  grid.setSize(25);
  noFill();
  drawGrid(grid);
}

void drawGrid(RGrid grid) {

  // iterate of the elements of the grid
  for (int i = 0; i < grid.size(); i++) {

    // get location and dimension of the current element
    float x = grid.getX(i);
    float y = grid.getY(i);
    float w = grid.getWidth(i);
    float h = grid.getHeight(i);

    // draw ellipse with the given location and dimension
    ellipse(x, y, w, h);
  }
}

void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}