import net.returnvoid.analytics.*;
import net.returnvoid.color.*;
import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketchs demonstates how to create
 * color palettes from images. The color palette
 * will consists of n colors, where n is the optimal number
 * of colors to represent that image.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

// the measure defines how the colors are detected in the image
ColorDifferenceMeasure measure = ColorDifferenceMeasure.LCHEuclidean;

// a container that will create the color palettes
// and will find the optimal number of colors
ColorClusteringBuilder builder;

// loader that handles the loading of images
ImageLoader loader;

void setup() {
  size(1280, 720);
  
  // create loader and get a image
  // a new image will be loaded on mouse click
  loader = new ImageLoader(this);
  
  // create a new clustering builder and set its measure
  builder = new ColorClusteringBuilder(this, measure);
  
  // conntect loader and builder
  // the builder will be informed as soon as a new image is loaded
  loader.addObserver(builder);
  loader.nextRandom();
}

void draw() {
  background(247);
  PImage img = loader.getCurrent();
  
   // get clustering with optimal colors for the image
  ColorClustering optimalClustering = builder.getClustering();
  
  // convert the clustering to palette
  ColorPalette palette = optimalClustering.toColorPalette();
  palette.sort("hue");
  
  float h = 500;
  float w = img.width * h / img.height;
  
  float x = width * 0.5 - w * 0.5;
  float y = 25;
  
  // draw image and color palette
  image(img, x, y, w, h);
  palette.draw(this, x, y + h + 25, w, height - h - 75);
}

void mousePressed() {
  loader.nextRandom();
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}