import net.returnvoid.analytics.*;
import net.returnvoid.color.*;
import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketchs demonstates how to create
 * color palettes with a given number of
 * colors from images. 
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */


// the number of colors the palettes will have
int numberOfColors = 7;

// the measure defines how the colors are detected in the image
ColorDifferenceMeasure measure = ColorDifferenceMeasure.LCHEuclidean;

// to container for the colors
ColorPalette palette;

// loader that handles the loading of images
ImageLoader loader;

void setup() {
  size(1280, 720);
  
  // create loader and get a image
  // a new image will be loaded on mouse click
  loader = new ImageLoader(this);
  loader.nextRandom();
  loader.disableKeys();
  
  // get 420 sampled colors from the image
  RColor[] training = ClusteringHelper.getTrainingColors(loader.getCurrent(), 420, measure);
  
  // get clustering (learn similarities in the sampled colors)
  ColorClustering clustering = ClusteringHelper.kmeans(training, numberOfColors, measure);
  
  // convert clustering to color palette
  palette = clustering.toColorPalette();
}

void draw() {
  background(247);
  PImage img = loader.getCurrent();
  
  float h = 500;
  float w = img.width * h / img.height;
  
  float x = width * 0.5 - w * 0.5;
  float y = 25;
  
  // draw image and color palette
  image(loader.getCurrent(), x, y, w, h);
  palette.draw(this, x, y + h + 25, w, height - h - 75);
}

void mousePressed() {
  // get new image
  loader.nextRandom();
  
  // get 420 sampled colors from the image
  RColor[] training = ClusteringHelper.getTrainingColors(loader.getCurrent(), 420, measure);
  
  // get clustering (learn similarities in the sampled colors)
  ColorClustering clustering = ClusteringHelper.kmeans(training, numberOfColors, measure);
  
  // convert clustering to color palette
  palette = clustering.toColorPalette();
}

void keyPressed() {
  if (key == 'p') {
    saveFrame("export/" + StringTools.timestamp() + ".png");
  }
}