import net.returnvoid.analytics.*;
import net.returnvoid.color.*;
import net.returnvoid.graphics.grid.*;
import net.returnvoid.io.*;
import net.returnvoid.tools.*;

/**
 * This sketch shows how to get training colors (randomly sampled colors) from an image or a color array which
 * might be used for a clustering.
 *
 * This code is copyright (c) Diana Lange 2017
 *
 * The library is published under the Creative Commons license NonCommercial 4.0.
 * Please check https://creativecommons.org/licenses/by-nc/4.0/ for more information.
 * 
 * This program is distributed in the hope that it will be useful, but without any warranty.
 */

ImageLoader loader;

void setup() {
  size(1280, 720);
  
  loader = new ImageLoader(this);
  noLoop();
}

void draw() {
  
  // get an image
  PImage img = loader.nextRandom();
  
  // training colors can either be created from an image or an existing array of colors
  
  // (1) create training data from image ----------------------------------------------------------
  
  
  // set a color space. All colors of the 'imgColors' Array will be converted to that color space
  ColorSpace space = ColorSpace.LCHColor;
  
  // get 420 sampled colors from the image
  RColor[] imgColors = ClusteringHelper.getTrainingColors(img, 420, space);
  
  // draw the sampled colors
  TableGrid grid1 = GridMaker.createTable(0, 0, width, height * 0.5, imgColors.length, 1);
  for (int i = 0; i < grid1.size(); i++) {
    float w = grid1.getWidth(i);
    float h = grid1.getHeight(i);
    float x = grid1.getX(i);
    float y = grid1.getY(i);
    
    color c = imgColors[i].getColor();
    
    fill(c);
    stroke(c);
    rect(x - w * 0.5, y - h * 0.5, w, h);
  } 
  
  // (2) create training data from color array ----------------------------------------------------------
  
  // if the training colors are created from an array
  // the getTrainingColors() method shuffles the input array and returns a sub set of that shuffled array
  
  // get 100 random choosen colors from the input array 
  RColor[] shuffledSubset = ClusteringHelper.getTrainingColors(imgColors, 100, space);
  
  // draw the sampled colors
  TableGrid grid2 = GridMaker.createTable(0, height * 0.5, width, height * 0.5, shuffledSubset.length, 1);
  for (int i = 0; i < grid2.size(); i++) {
    float w = grid2.getWidth(i);
    float h = grid2.getHeight(i);
    float x = grid2.getX(i);
    float y = grid2.getY(i);
    
    color c = shuffledSubset[i].getColor();
    
    fill(c);
    stroke(c);
    rect(x - w * 0.5, y - h * 0.5, w, h);
  } 
}

void mousePressed() {
  redraw();
}


void keyPressed() {
  saveFrame("export/" + StringTools.timestamp() + ".png");
}