/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.tools;

import java.util.ArrayList;
import java.util.Calendar;

public class StringTools {
    private StringTools() {
    }

    public static String timestamp() {
        return String.format("%1$tY%1$tm%1$td_%1$tH%1$tM%1$tS", Calendar.getInstance());
    }

    public static String nf(int val, int digits) {
        return StringTools.nfs(val, digits, 0);
    }

    public static String nfs(float val, int d1, int d2) {
        int num;
        String sub2;
        String txt = "" + val;
        String[] splitted = (txt = txt.replaceAll("[+-]", "")).split("[.,]");
        String sub1 = splitted.length > 0 ? splitted[0] : txt;
        String string = sub2 = splitted.length > 1 ? splitted[1] : "0";
        if (sub1.length() < d1) {
            num = d1 - sub1.length() - 1;
            num = (int)Math.pow(10.0, num);
            sub1 = String.valueOf(("" + num).replaceAll("\\d", "0")) + sub1;
        } else if (sub1.length() > d1) {
            sub1 = sub1.substring(sub1.length() - d1, sub1.length());
        }
        if (sub2.length() < d2) {
            num = d2 - sub2.length() - 1;
            num = (int)Math.pow(10.0, num);
            sub2 = String.valueOf(sub2) + ("" + num).replaceAll("\\d", "0");
        } else if (sub2.length() > d2) {
            sub2 = sub2.substring(0, d2);
        }
        return String.valueOf(val < 0.0f ? "-" : "+") + sub1 + (sub2.length() > 0 ? "." + sub2 : "");
    }

    public static String join(float[] list, String separator) {
        String txt = "";
        float[] fArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            float t = fArray[n2];
            txt = String.valueOf(txt) + t + separator;
            ++n2;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String join(int[] list, String separator) {
        String txt = "";
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            txt = String.valueOf(txt) + t + separator;
            ++n2;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String join(String separator, Object ... elements) {
        return StringTools.join(elements, separator);
    }

    public static String join(Object[] list, String separator) {
        String txt = "";
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object t = objectArray[n2];
            txt = String.valueOf(txt) + t + separator;
            ++n2;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String join(ArrayList<String> list, String separator) {
        String txt = "";
        for (String t : list) {
            txt = String.valueOf(txt) + t + separator;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String joinAndFormat(float[] list, String separator, int d1, int d2) {
        String txt = "";
        float[] fArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            float t = fArray[n2];
            txt = String.valueOf(txt) + StringTools.nfs(t, d1, d2) + separator;
            ++n2;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String joinAndFormat(int[] list, String separator, int digits) {
        String txt = "";
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            txt = String.valueOf(txt) + StringTools.nf(t, digits) + separator;
            ++n2;
        }
        return txt.substring(0, txt.length() - separator.length());
    }

    public static String getStringEcp(String txt) {
        return "\"" + txt + "\"";
    }

    public static String getKeyValue(String key, ArrayList<String> values) {
        String txt = "";
        if (values != null && values.size() > 0) {
            for (String v : values) {
                txt = String.valueOf(txt) + StringTools.getStringEcp(v) + ",";
            }
            txt = txt.substring(0, txt.length() - 1);
        }
        return String.valueOf(StringTools.getStringEcp(key)) + " : [" + txt + "]";
    }

    public static String getKeyValue(String key, String value, boolean escapeValue) {
        return String.valueOf(StringTools.getStringEcp(key)) + " : " + (escapeValue ? StringTools.getStringEcp(value) : value);
    }

    public static String getKeyValue(String key, String value) {
        return String.valueOf(StringTools.getStringEcp(key)) + " : " + StringTools.getStringEcp(value);
    }
}

