/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.tools;

import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;
import processing.core.PVector;

public class RMath {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;

    private RMath() {
    }

    public static PVector polarToCartesian(Float a, float r) {
        return new PVector((float)(Math.cos(a.floatValue()) * (double)r), (float)(Math.sin(a.floatValue()) * (double)r));
    }

    public static PVector polarToCartesian(PVector base, float a, float r) {
        return new PVector((float)((double)base.x + Math.cos(a) * (double)r), (float)((double)base.y + Math.sin(a) * (double)r));
    }

    public static PVector polarToCartesian(float basex, float basey, float a, float r) {
        return new PVector((float)((double)basex + Math.cos(a) * (double)r), (float)((double)basey + Math.sin(a) * (double)r));
    }

    public static float constrain(float input, float min, float max) {
        return input >= min && input <= max ? input : (input < min ? min : max);
    }

    public static Integer constrain(int input, int min, int max) {
        return input >= min && input <= max ? input : (input < min ? min : max);
    }

    public static float map(float input, float inputStart, float inputEnd, float outputStart, float outputEnd) {
        if (inputEnd - inputStart == 0.0f || outputEnd - outputStart == 0.0f) {
            return outputStart;
        }
        float x = (input - inputStart) / (inputEnd - inputStart);
        return outputStart + x * (outputEnd - outputStart);
    }

    public static float random(float max) {
        return RMath.random(0.0f, max);
    }

    public static float random(float min, float max) {
        if (min > max) {
            float tmp = min;
            min = max;
            max = tmp;
        }
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static int random(int max) {
        return (int)RMath.random(0.0f, (float)max);
    }

    public static int random(int min, int max) {
        return (int)RMath.random((float)min, (float)max);
    }

    public static float abs(float val) {
        return val < 0.0f ? val * -1.0f : val;
    }

    public static int abs(int val) {
        return val < 0 ? val * -1 : val;
    }

    public static float min(float ... vals) {
        if (vals == null || vals.length == 0) {
            return -1.0f;
        }
        float m = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < m) {
                m = vals[i];
            }
            ++i;
        }
        return m;
    }

    public static int min(int ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        int m = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < m) {
                m = vals[i];
            }
            ++i;
        }
        return m;
    }

    public static float[] min(ColorSpace space, RColor ... vals) {
        float[] mins = new float[4];
        if (vals == null || vals.length == 0) {
            return mins;
        }
        RColor target = ColorHelper.convert(vals[0], space);
        switch (space) {
            case HSBColor: {
                mins[0] = ((HSBColor)target).getHue().floatValue();
                mins[1] = ((HSBColor)target).getSaturation().floatValue();
                mins[2] = ((HSBColor)target).getBrightness().floatValue();
                break;
            }
            case XYZColor: {
                mins[0] = ((XYZColor)target).getX().floatValue();
                mins[1] = ((XYZColor)target).getY().floatValue();
                mins[2] = ((XYZColor)target).getZ().floatValue();
                break;
            }
            case LabColor: {
                mins[0] = ((LabColor)target).getLuminance();
                mins[1] = ((LabColor)target).getA().floatValue();
                mins[2] = ((LabColor)target).getB().floatValue();
                break;
            }
            case LCHColor: {
                mins[0] = ((LCHColor)target).getLuminance().floatValue();
                mins[1] = ((LCHColor)target).getChroma().floatValue();
                mins[2] = ((LCHColor)target).getHue().floatValue();
                break;
            }
            default: {
                mins[0] = ((RGBColor)target).getRed().floatValue();
                mins[1] = ((RGBColor)target).getGreen().floatValue();
                mins[2] = ((RGBColor)target).getBlue().floatValue();
            }
        }
        mins[2] = target.getAlpha().floatValue();
        int i = 1;
        while (i < vals.length) {
            target = ColorHelper.convert(vals[1], space);
            float v1 = 0.0f;
            float v2 = 0.0f;
            float v3 = 0.0f;
            float v4 = target.getAlpha().floatValue();
            switch (space) {
                case HSBColor: {
                    v1 = ((HSBColor)target).getHue().floatValue();
                    v2 = ((HSBColor)target).getSaturation().floatValue();
                    v3 = ((HSBColor)target).getBrightness().floatValue();
                    break;
                }
                case XYZColor: {
                    v1 = ((XYZColor)target).getX().floatValue();
                    v2 = ((XYZColor)target).getY().floatValue();
                    v3 = ((XYZColor)target).getZ().floatValue();
                    break;
                }
                case LabColor: {
                    v1 = ((LabColor)target).getLuminance();
                    v2 = ((LabColor)target).getA().floatValue();
                    v3 = ((LabColor)target).getB().floatValue();
                    break;
                }
                case LCHColor: {
                    v1 = ((LCHColor)target).getLuminance().floatValue();
                    v2 = ((LCHColor)target).getChroma().floatValue();
                    v3 = ((LCHColor)target).getHue().floatValue();
                    break;
                }
                default: {
                    v1 = ((RGBColor)target).getRed().floatValue();
                    v2 = ((RGBColor)target).getGreen().floatValue();
                    v3 = ((RGBColor)target).getBlue().floatValue();
                }
            }
            if (v1 < mins[0]) {
                mins[0] = v1;
            }
            if (v2 < mins[1]) {
                mins[1] = v2;
            }
            if (v3 < mins[2]) {
                mins[2] = v3;
            }
            if (v4 < mins[3]) {
                mins[3] = v4;
            }
            ++i;
        }
        return mins;
    }

    public static float min(char channel, RColor ... vals) {
        if (vals == null || vals.length == 0) {
            return -1.0f;
        }
        ColorSpace space = vals[0].getColorSpace();
        float m = 0.0f;
        if (channel != 't') {
            switch (space) {
                case HSBColor: {
                    if (channel == 'h') {
                        m = vals[0].toHSB().getHue().floatValue();
                        break;
                    }
                    if (channel == 's') {
                        m = vals[0].toHSB().getSaturation().floatValue();
                        break;
                    }
                    m = vals[0].toHSB().getBrightness().floatValue();
                    break;
                }
                case XYZColor: {
                    if (channel == 'x') {
                        m = vals[0].toXYZ().getX().floatValue();
                        break;
                    }
                    if (channel == 'y') {
                        m = vals[0].toXYZ().getY().floatValue();
                        break;
                    }
                    m = vals[0].toXYZ().getZ().floatValue();
                    break;
                }
                case LabColor: {
                    if (channel == 'l') {
                        m = vals[0].toLab().getLuminance();
                        break;
                    }
                    if (channel == 'a') {
                        m = vals[0].toLab().getA().floatValue();
                        break;
                    }
                    m = vals[0].toLab().getB().floatValue();
                    break;
                }
                case LCHColor: {
                    if (channel == 'l') {
                        m = vals[0].toLCH().getLuminance().floatValue();
                        break;
                    }
                    if (channel == 'c') {
                        m = vals[0].toLCH().getChroma().floatValue();
                        break;
                    }
                    m = vals[0].toLCH().getHue().floatValue();
                    break;
                }
                default: {
                    if (channel == 'r') {
                        m = vals[0].toRGB().getRed().floatValue();
                        break;
                    }
                    if (channel == 'g') {
                        m = vals[0].toRGB().getGreen().floatValue();
                        break;
                    }
                    m = vals[0].toRGB().getBlue().floatValue();
                    break;
                }
            }
        } else {
            m = vals[0].getAlpha().floatValue();
        }
        int i = 1;
        while (i < vals.length) {
            float tmp = 0.0f;
            if (channel != 't') {
                switch (space) {
                    case HSBColor: {
                        if (channel == 'h') {
                            tmp = vals[i].toHSB().getHue().floatValue();
                            break;
                        }
                        if (channel == 's') {
                            tmp = vals[i].toHSB().getSaturation().floatValue();
                            break;
                        }
                        tmp = vals[i].toHSB().getBrightness().floatValue();
                        break;
                    }
                    case XYZColor: {
                        if (channel == 'x') {
                            tmp = vals[i].toXYZ().getX().floatValue();
                            break;
                        }
                        if (channel == 'y') {
                            tmp = vals[i].toXYZ().getY().floatValue();
                            break;
                        }
                        tmp = vals[i].toXYZ().getZ().floatValue();
                        break;
                    }
                    case LabColor: {
                        if (channel == 'l') {
                            tmp = vals[i].toLab().getLuminance();
                            break;
                        }
                        if (channel == 'a') {
                            tmp = vals[i].toLab().getA().floatValue();
                            break;
                        }
                        tmp = vals[i].toLab().getB().floatValue();
                        break;
                    }
                    case LCHColor: {
                        if (channel == 'l') {
                            tmp = vals[i].toLCH().getLuminance().floatValue();
                            break;
                        }
                        if (channel == 'c') {
                            tmp = vals[i].toLCH().getChroma().floatValue();
                            break;
                        }
                        tmp = vals[i].toLCH().getHue().floatValue();
                        break;
                    }
                    default: {
                        if (channel == 'r') {
                            tmp = vals[i].toRGB().getRed().floatValue();
                            break;
                        }
                        if (channel == 'g') {
                            tmp = vals[i].toRGB().getGreen().floatValue();
                            break;
                        }
                        tmp = vals[i].toRGB().getBlue().floatValue();
                        break;
                    }
                }
            } else {
                tmp = vals[i].getAlpha().floatValue();
            }
            if (tmp < m) {
                m = tmp;
            }
            ++i;
        }
        return m;
    }

    public static float max(float ... vals) {
        if (vals == null || vals.length == 0) {
            return -1.0f;
        }
        float m = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (vals[i] > m) {
                m = vals[i];
            }
            ++i;
        }
        return m;
    }

    public static int max(int ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        int m = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (vals[i] > m) {
                m = vals[i];
            }
            ++i;
        }
        return m;
    }

    public static float max(char channel, RColor ... vals) {
        if (vals == null || vals.length == 0) {
            return -1.0f;
        }
        ColorSpace space = vals[0].getColorSpace();
        float m = 0.0f;
        if (channel != 't') {
            switch (space) {
                case HSBColor: {
                    if (channel == 'h') {
                        m = vals[0].toHSB().getHue().floatValue();
                        break;
                    }
                    if (channel == 's') {
                        m = vals[0].toHSB().getSaturation().floatValue();
                        break;
                    }
                    m = vals[0].toHSB().getBrightness().floatValue();
                    break;
                }
                case XYZColor: {
                    if (channel == 'x') {
                        m = vals[0].toXYZ().getX().floatValue();
                        break;
                    }
                    if (channel == 'y') {
                        m = vals[0].toXYZ().getY().floatValue();
                        break;
                    }
                    m = vals[0].toXYZ().getZ().floatValue();
                    break;
                }
                case LabColor: {
                    if (channel == 'l') {
                        m = vals[0].toLab().getLuminance();
                        break;
                    }
                    if (channel == 'a') {
                        m = vals[0].toLab().getA().floatValue();
                        break;
                    }
                    m = vals[0].toLab().getB().floatValue();
                    break;
                }
                case LCHColor: {
                    if (channel == 'l') {
                        m = vals[0].toLCH().getLuminance().floatValue();
                        break;
                    }
                    if (channel == 'c') {
                        m = vals[0].toLCH().getChroma().floatValue();
                        break;
                    }
                    m = vals[0].toLCH().getHue().floatValue();
                    break;
                }
                default: {
                    if (channel == 'r') {
                        m = vals[0].toRGB().getRed().floatValue();
                        break;
                    }
                    if (channel == 'g') {
                        m = vals[0].toRGB().getGreen().floatValue();
                        break;
                    }
                    m = vals[0].toRGB().getBlue().floatValue();
                    break;
                }
            }
        } else {
            m = vals[0].getAlpha().floatValue();
        }
        int i = 1;
        while (i < vals.length) {
            float tmp = 0.0f;
            if (channel != 't') {
                switch (space) {
                    case HSBColor: {
                        if (channel == 'h') {
                            tmp = vals[i].toHSB().getHue().floatValue();
                            break;
                        }
                        if (channel == 's') {
                            tmp = vals[i].toHSB().getSaturation().floatValue();
                            break;
                        }
                        tmp = vals[i].toHSB().getBrightness().floatValue();
                        break;
                    }
                    case XYZColor: {
                        if (channel == 'x') {
                            tmp = vals[i].toXYZ().getX().floatValue();
                            break;
                        }
                        if (channel == 'y') {
                            tmp = vals[i].toXYZ().getY().floatValue();
                            break;
                        }
                        tmp = vals[i].toXYZ().getZ().floatValue();
                        break;
                    }
                    case LabColor: {
                        if (channel == 'l') {
                            tmp = vals[i].toLab().getLuminance();
                            break;
                        }
                        if (channel == 'a') {
                            tmp = vals[i].toLab().getA().floatValue();
                            break;
                        }
                        tmp = vals[i].toLab().getB().floatValue();
                        break;
                    }
                    case LCHColor: {
                        if (channel == 'l') {
                            tmp = vals[i].toLCH().getLuminance().floatValue();
                            break;
                        }
                        if (channel == 'c') {
                            tmp = vals[i].toLCH().getChroma().floatValue();
                            break;
                        }
                        tmp = vals[i].toLCH().getHue().floatValue();
                        break;
                    }
                    default: {
                        if (channel == 'r') {
                            tmp = vals[i].toRGB().getRed().floatValue();
                            break;
                        }
                        if (channel == 'g') {
                            tmp = vals[i].toRGB().getGreen().floatValue();
                            break;
                        }
                        tmp = vals[i].toRGB().getBlue().floatValue();
                        break;
                    }
                }
            } else {
                tmp = vals[i].getAlpha().floatValue();
            }
            if (tmp > m) {
                m = tmp;
            }
            ++i;
        }
        return m;
    }

    public static float[] max(ColorSpace space, RColor ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        float[] maxs = new float[4];
        RColor target = ColorHelper.convert(vals[0], space);
        switch (space) {
            case HSBColor: {
                maxs[0] = ((HSBColor)target).getHue().floatValue();
                maxs[1] = ((HSBColor)target).getSaturation().floatValue();
                maxs[2] = ((HSBColor)target).getBrightness().floatValue();
                break;
            }
            case XYZColor: {
                maxs[0] = ((XYZColor)target).getX().floatValue();
                maxs[1] = ((XYZColor)target).getY().floatValue();
                maxs[2] = ((XYZColor)target).getZ().floatValue();
                break;
            }
            case LabColor: {
                maxs[0] = ((LabColor)target).getLuminance();
                maxs[1] = ((LabColor)target).getA().floatValue();
                maxs[2] = ((LabColor)target).getB().floatValue();
                break;
            }
            case LCHColor: {
                maxs[0] = ((LCHColor)target).getLuminance().floatValue();
                maxs[1] = ((LCHColor)target).getChroma().floatValue();
                maxs[2] = ((LCHColor)target).getHue().floatValue();
                break;
            }
            default: {
                maxs[0] = ((RGBColor)target).getRed().floatValue();
                maxs[1] = ((RGBColor)target).getGreen().floatValue();
                maxs[2] = ((RGBColor)target).getBlue().floatValue();
            }
        }
        maxs[2] = target.getAlpha().floatValue();
        int i = 1;
        while (i < vals.length) {
            target = ColorHelper.convert(vals[1], space);
            float v1 = 0.0f;
            float v2 = 0.0f;
            float v3 = 0.0f;
            float v4 = target.getAlpha().floatValue();
            switch (space) {
                case HSBColor: {
                    v1 = ((HSBColor)target).getHue().floatValue();
                    v2 = ((HSBColor)target).getSaturation().floatValue();
                    v3 = ((HSBColor)target).getBrightness().floatValue();
                    break;
                }
                case XYZColor: {
                    v1 = ((XYZColor)target).getX().floatValue();
                    v2 = ((XYZColor)target).getY().floatValue();
                    v3 = ((XYZColor)target).getZ().floatValue();
                    break;
                }
                case LabColor: {
                    v1 = ((LabColor)target).getLuminance();
                    v2 = ((LabColor)target).getA().floatValue();
                    v3 = ((LabColor)target).getB().floatValue();
                    break;
                }
                case LCHColor: {
                    v1 = ((LCHColor)target).getLuminance().floatValue();
                    v2 = ((LCHColor)target).getChroma().floatValue();
                    v3 = ((LCHColor)target).getHue().floatValue();
                    break;
                }
                default: {
                    v1 = ((RGBColor)target).getRed().floatValue();
                    v2 = ((RGBColor)target).getGreen().floatValue();
                    v3 = ((RGBColor)target).getBlue().floatValue();
                }
            }
            if (v1 > maxs[0]) {
                maxs[0] = v1;
            }
            if (v2 > maxs[1]) {
                maxs[1] = v2;
            }
            if (v3 > maxs[2]) {
                maxs[2] = v3;
            }
            if (v4 > maxs[3]) {
                maxs[3] = v4;
            }
            ++i;
        }
        return maxs;
    }

    public static int[] range(int ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        int[] minmax = new int[]{vals[0], vals[2]};
        int i = 1;
        while (i < vals.length) {
            int val = vals[i];
            if (val < minmax[0]) {
                minmax[0] = val;
            }
            if (val > minmax[1]) {
                minmax[1] = val;
            }
            ++i;
        }
        return minmax;
    }

    public static float[] range(float ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        float[] minmax = new float[]{vals[0], vals[2]};
        int i = 1;
        while (i < vals.length) {
            float val = vals[i];
            if (val < minmax[0]) {
                minmax[0] = val;
            }
            if (val > minmax[1]) {
                minmax[1] = val;
            }
            ++i;
        }
        return minmax;
    }

    public static float[] range(ColorSpace space, RColor ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        float[] minmax = new float[8];
        RColor target = ColorHelper.convert(vals[0], space);
        float v1 = 0.0f;
        float v2 = 0.0f;
        float v3 = 0.0f;
        float v4 = target.getAlpha().floatValue();
        switch (space) {
            case HSBColor: {
                v1 = ((HSBColor)target).getHue().floatValue();
                v2 = ((HSBColor)target).getSaturation().floatValue();
                v3 = ((HSBColor)target).getBrightness().floatValue();
                break;
            }
            case XYZColor: {
                v1 = ((XYZColor)target).getX().floatValue();
                v2 = ((XYZColor)target).getY().floatValue();
                v3 = ((XYZColor)target).getZ().floatValue();
                break;
            }
            case LabColor: {
                v1 = ((LabColor)target).getLuminance();
                v2 = ((LabColor)target).getA().floatValue();
                v3 = ((LabColor)target).getB().floatValue();
                break;
            }
            case LCHColor: {
                v1 = ((LCHColor)target).getLuminance().floatValue();
                v2 = ((LCHColor)target).getChroma().floatValue();
                v3 = ((LCHColor)target).getHue().floatValue();
                break;
            }
            default: {
                v1 = ((RGBColor)target).getRed().floatValue();
                v2 = ((RGBColor)target).getGreen().floatValue();
                v3 = ((RGBColor)target).getBlue().floatValue();
            }
        }
        minmax[0] = minmax[4] = v1;
        minmax[1] = minmax[5] = v2;
        minmax[2] = minmax[6] = v3;
        minmax[3] = minmax[7] = v4;
        int i = 1;
        while (i < vals.length) {
            target = ColorHelper.convert(vals[i], space);
            v4 = target.getAlpha().floatValue();
            switch (space) {
                case HSBColor: {
                    v1 = ((HSBColor)target).getHue().floatValue();
                    v2 = ((HSBColor)target).getSaturation().floatValue();
                    v3 = ((HSBColor)target).getBrightness().floatValue();
                    break;
                }
                case XYZColor: {
                    v1 = ((XYZColor)target).getX().floatValue();
                    v2 = ((XYZColor)target).getY().floatValue();
                    v3 = ((XYZColor)target).getZ().floatValue();
                    break;
                }
                case LabColor: {
                    v1 = ((LabColor)target).getLuminance();
                    v2 = ((LabColor)target).getA().floatValue();
                    v3 = ((LabColor)target).getB().floatValue();
                    break;
                }
                case LCHColor: {
                    v1 = ((LCHColor)target).getLuminance().floatValue();
                    v2 = ((LCHColor)target).getChroma().floatValue();
                    v3 = ((LCHColor)target).getHue().floatValue();
                    break;
                }
                default: {
                    v1 = ((RGBColor)target).getRed().floatValue();
                    v2 = ((RGBColor)target).getGreen().floatValue();
                    v3 = ((RGBColor)target).getBlue().floatValue();
                }
            }
            if (v1 < minmax[0]) {
                minmax[0] = v1;
            }
            if (v2 < minmax[1]) {
                minmax[1] = v2;
            }
            if (v3 < minmax[2]) {
                minmax[2] = v3;
            }
            if (v4 < minmax[3]) {
                minmax[3] = v4;
            }
            if (v1 > minmax[4]) {
                minmax[4] = v1;
            }
            if (v2 > minmax[5]) {
                minmax[5] = v2;
            }
            if (v3 > minmax[6]) {
                minmax[6] = v3;
            }
            if (v4 > minmax[7]) {
                minmax[7] = v4;
            }
            ++i;
        }
        return minmax;
    }

    public static float[] range(PVector ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        float minX = vals[0].x;
        float maxX = vals[0].x;
        float minY = vals[0].y;
        float maxY = vals[0].y;
        int i = 1;
        while (i < vals.length) {
            PVector p = vals[i];
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y > maxY) {
                maxY = p.y;
            }
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            ++i;
        }
        return new float[]{minX, minY, maxX, maxY};
    }

    public static int minIndex(int ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        int m = vals[0];
        int index = 0;
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < m) {
                m = vals[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int minIndex(float ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        float m = vals[0];
        int index = 0;
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < m) {
                m = vals[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int maxIndex(int ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        int m = vals[0];
        int index = 0;
        int i = 1;
        while (i < vals.length) {
            if (vals[i] > m) {
                m = vals[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int maxIndex(float ... vals) {
        if (vals == null || vals.length == 0) {
            return -1;
        }
        float m = vals[0];
        int index = 0;
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < m) {
                m = vals[i];
                index = i;
            }
            ++i;
        }
        return index;
    }
}

