/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.io;

import java.util.ArrayList;
import net.returnvoid.io.DataLoader;
import net.returnvoid.io.ImageUpdateObserver;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PImage;

public class ImageLoader
extends DataLoader {
    private PImage[] images;
    private boolean autoResize = true;
    private ArrayList<ImageUpdateObserver> observers = new ArrayList();

    public ImageLoader(PApplet parent) {
        this(parent, null, "data", false);
    }

    public ImageLoader(PApplet parent, boolean autoResize) {
        this(parent, null, "data", autoResize);
    }

    public ImageLoader(PApplet parent, String folderName) {
        this(parent, null, folderName, false);
    }

    public ImageLoader(PApplet parent, String folderName, boolean autoResize) {
        this(parent, null, folderName, autoResize);
    }

    public ImageLoader(PApplet parent, String folderPath, String folderName) {
        this(parent, folderPath, folderName, true);
    }

    public ImageLoader(PApplet parent, String folderPath, String folderName, boolean autoResize) {
        super(parent, folderPath, folderName);
        this.autoResize = autoResize;
        this.type = 0;
        this.filePaths = this.loadPaths(this.type);
        this.images = new PImage[this.filePaths.length];
    }

    @Override
    public ImageLoader update() {
        super.update();
        this.fileIndex = 0;
        this.filePaths = this.loadPaths(this.type);
        this.images = new PImage[this.filePaths.length];
        return this;
    }

    @Override
    public ImageLoader resetKeySettings() {
        return (ImageLoader)super.resetKeySettings();
    }

    @Override
    public ImageLoader disableKeys() {
        return (ImageLoader)super.disableKeys();
    }

    @Override
    public ImageLoader enableKeys() {
        return (ImageLoader)super.enableKeys();
    }

    @Override
    public DataLoader setKey(String which, int keyCode) {
        return (ImageLoader)super.setKey(which, keyCode);
    }

    @Override
    public ImageLoader setKey(String which, char key) {
        return (ImageLoader)super.setKey(which, key);
    }

    public ImageLoader enableAutoResize() {
        this.autoResize = true;
        return this;
    }

    public ImageLoader disableAutoResize() {
        this.autoResize = false;
        return this;
    }

    public PImage loadFile(int index) {
        index = RMath.constrain(index, 0, this.filePaths.length);
        PImage img = this.parent.loadImage(this.filePaths[index]);
        if (this.autoResize) {
            img.resize(this.parent.width, this.parent.height);
        }
        img.loadPixels();
        this.images[index] = img;
        return img;
    }

    public PImage[] loadAllFiles() {
        int i = 0;
        while (i < this.images.length) {
            if (this.images[i] == null) {
                this.loadFile(i);
            }
            ++i;
        }
        return this.images;
    }

    public PImage nextRandom() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = RMath.random(0, this.filePaths.length);
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.images[this.fileIndex];
    }

    public PImage previous() {
        if (this.filePaths.length == 0) {
            return null;
        }
        int n = this.fileIndex = --this.fileIndex >= 0 ? this.fileIndex : this.filePaths.length - 1;
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.images[this.fileIndex];
    }

    public PImage next() {
        if (this.filePaths.length == 0) {
            return null;
        }
        int n = this.fileIndex = ++this.fileIndex < this.filePaths.length ? this.fileIndex : 0;
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.images[this.fileIndex];
    }

    public PImage first() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = 0;
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.images[this.fileIndex];
    }

    public PImage last() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = this.filePaths.length - 1;
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.images[this.fileIndex];
    }

    @Override
    public ImageLoader setIndex(int index) {
        super.setIndex(index);
        this.informObservers();
        return this;
    }

    @Override
    public ImageLoader setIndex(String filename) {
        super.setIndex(filename);
        this.informObservers();
        return this;
    }

    public PImage getCurrent() {
        if (this.images[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        return this.images[this.fileIndex];
    }

    public PImage get(int index) {
        if (this.images[index = RMath.constrain(index, 0, this.filePaths.length).intValue()] == null) {
            this.loadFile(index);
        }
        return this.images[index];
    }

    public ImageLoader addObserver(ImageUpdateObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public ImageLoader removeObserver(ImageUpdateObserver observer) {
        this.observers.remove(observer);
        return this;
    }

    public ImageLoader clearObservers() {
        this.observers.clear();
        return this;
    }

    private void informObservers() {
        for (ImageUpdateObserver o : this.observers) {
            o.setImage(this.getCurrent());
        }
    }
}

