/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.io;

import java.io.File;
import java.util.ArrayList;
import net.returnvoid.tools.ProcessingTools;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.event.KeyEvent;

public abstract class DataLoader {
    private int prevKey = 37;
    private int nextKey = 39;
    private int firstKey = 38;
    private int lastKey = 40;
    private int nextRandomKey = 9;
    protected PApplet parent;
    private boolean keysEnabled = true;
    private long lastTimeKeyPressed = -1L;
    protected String[] filePaths;
    protected int type;
    protected int fileIndex;
    public static final int IMAGE = 0;
    public static final int TEXT = 1;
    public static final int CSV = 2;
    public static final int JSON = 3;
    public static final int SHAPE = 4;
    public static final int XML = 5;
    public static final int COLOR_PALETTE = 6;
    private String folderName;
    private String folderPath;

    protected DataLoader(PApplet parent, String folderPath, String folderName) {
        this.parent = parent;
        this.folderPath = folderPath;
        this.folderName = folderName;
        this.resetKeySettings();
        this.keysEnabled = true;
        this.fileIndex = 0;
        this.parent.registerMethod("keyEvent", (Object)this);
    }

    public String getFolder() {
        return this.folderName;
    }

    public String getPath() {
        return this.folderPath == null ? ProcessingTools.getSketchPath(this.parent) : this.folderPath;
    }

    public String getLoadingDirectory() {
        return new File(String.valueOf(this.getPath()) + "/" + this.getFolder()).getAbsolutePath();
    }

    public abstract Object loadFile(int var1);

    public abstract Object[] loadAllFiles();

    public abstract Object nextRandom();

    public abstract Object previous();

    public abstract Object next();

    public abstract Object first();

    public abstract Object last();

    public abstract Object getCurrent();

    public abstract Object get(int var1);

    public DataLoader setIndex(int index) {
        this.fileIndex = RMath.constrain(index, 0, this.size());
        return this;
    }

    public DataLoader setIndex(String filename) {
        boolean found = false;
        int i = 0;
        while (i < this.filePaths.length) {
            File file = new File(this.filePaths[i]);
            if (file.exists() && file.getName().equals(filename)) {
                found = true;
                this.setIndex(i);
                break;
            }
            ++i;
        }
        if (!found) {
            System.err.println("The file \"" + filename + "\" could not be found at " + this.getPath());
        }
        return this;
    }

    public DataLoader resetKeySettings() {
        this.prevKey = 37;
        this.nextKey = 39;
        this.firstKey = 38;
        this.lastKey = 40;
        this.nextRandomKey = 9;
        return this;
    }

    public int size() {
        return this.filePaths.length;
    }

    public void keyEvent(KeyEvent evt) {
        if (this.keysEnabled && (this.lastTimeKeyPressed == -1L || System.currentTimeMillis() - this.lastTimeKeyPressed > 300L)) {
            if (evt.getKeyCode() == this.prevKey || evt.getKey() == this.prevKey) {
                this.previous();
            } else if (evt.getKeyCode() == this.nextKey || evt.getKey() == this.nextKey) {
                this.next();
            } else if (evt.getKeyCode() == this.nextRandomKey || evt.getKey() == this.nextRandomKey) {
                this.nextRandom();
            } else if (evt.getKeyCode() == this.lastKey || evt.getKey() == this.lastKey) {
                this.last();
            } else if (evt.getKeyCode() == this.firstKey || evt.getKey() == this.firstKey) {
                this.first();
            }
            this.lastTimeKeyPressed = System.currentTimeMillis();
        }
    }

    public DataLoader disableKeys() {
        this.keysEnabled = false;
        return this;
    }

    public DataLoader enableKeys() {
        this.keysEnabled = true;
        return this;
    }

    public DataLoader setKey(String which, int keyCode) {
        if (which.toLowerCase().contains("pre")) {
            this.prevKey = keyCode;
        } else if (which.toLowerCase().contains("nex")) {
            this.nextKey = keyCode;
        } else if (which.toLowerCase().contains("fir")) {
            this.firstKey = keyCode;
        } else if (which.toLowerCase().contains("las")) {
            this.lastKey = keyCode;
        } else if (which.toLowerCase().contains("ran")) {
            this.nextRandomKey = keyCode;
        }
        return this;
    }

    public DataLoader setKey(String which, char key) {
        char keyCode = key;
        if (which.toLowerCase().contains("pre")) {
            this.prevKey = keyCode;
        } else if (which.toLowerCase().contains("nex")) {
            this.nextKey = keyCode;
        } else if (which.toLowerCase().contains("fir")) {
            this.firstKey = keyCode;
        } else if (which.toLowerCase().contains("las")) {
            this.lastKey = keyCode;
        } else if (which.toLowerCase().contains("ran")) {
            this.nextRandomKey = keyCode;
        }
        return this;
    }

    private String[] getFileExtensions(int type) {
        if (type == 1) {
            return new String[]{".txt", ".TXT"};
        }
        if (type == 2) {
            return new String[]{".csv", ".CSV"};
        }
        if (type == 3) {
            return new String[]{".json", ".JSON"};
        }
        if (type == 5) {
            return new String[]{".xml, .html, .htm", ".XML", ".HTML", ".HTM"};
        }
        if (type == 4) {
            return new String[]{".csv", ".CSV"};
        }
        if (type == 6) {
            return new String[]{".color.json"};
        }
        return new String[]{".png", ".jpg", ".tif", ".jpeg", ".gif", ".PNG", ".JPG", ".TIF", ".JPEG", ".GIF"};
    }

    public String getFileName(int index, boolean removeFileType) {
        index = RMath.constrain(index, 0, this.filePaths.length - 1);
        String fullPath = this.filePaths[index];
        String[] split = fullPath.split("\\\\");
        return !removeFileType ? split[split.length - 1] : split[split.length - 1].substring(0, split[split.length - 1].indexOf("."));
    }

    public String getFileName(int index) {
        return this.getFileName(index, false);
    }

    public String getFileName() {
        return this.getFileName(this.fileIndex, false);
    }

    public String getFileName(boolean removeFileType) {
        return this.getFileName(this.fileIndex, removeFileType);
    }

    public DataLoader update() {
        String oldPath = this.filePaths[this.fileIndex];
        this.fileIndex = 0;
        this.filePaths = this.loadPaths(this.type);
        int i = 0;
        while (i < this.filePaths.length) {
            if (this.filePaths[i].equals(oldPath)) {
                this.fileIndex = i;
                break;
            }
            ++i;
        }
        return this;
    }

    protected String[] loadPaths(int type) {
        return this.loadPaths(this.getFileExtensions(type));
    }

    protected String[] loadPaths(String[] dataTypes) {
        ArrayList<String> paths = new ArrayList<String>();
        File directory = new File(this.getLoadingDirectory());
        if (directory != null) {
            if (directory.exists() && directory.isDirectory()) {
                String[] imagPath = directory.list();
                int i = 0;
                while (i < imagPath.length) {
                    File file = new File(directory, imagPath[i]);
                    if (file.isFile()) {
                        String absolutePath = file.getAbsolutePath();
                        int j = 0;
                        while (j < dataTypes.length) {
                            if (absolutePath.indexOf(dataTypes[j]) != -1) {
                                paths.add(absolutePath);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                System.err.println("couldn't find directory");
            }
        }
        if (paths.size() == 0) {
            System.err.println("no matching file types found at directory " + directory.getAbsolutePath());
        }
        this.fileIndex = 0;
        return paths.toArray(new String[paths.size()]);
    }
}

