/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.io;

import java.util.ArrayList;
import net.returnvoid.color.ColorPalette;
import net.returnvoid.io.ColorPaletteUpdateObserver;
import net.returnvoid.io.DataLoader;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;
import processing.core.PApplet;

public class ColorPaletteLoader
extends DataLoader {
    private ColorPalette[] palettes;
    private ArrayList<ColorPaletteUpdateObserver> observers = new ArrayList();

    public ColorPaletteLoader(PApplet parent) {
        this(parent, null, "data");
    }

    public ColorPaletteLoader(PApplet parent, String folderName) {
        this(parent, null, folderName);
    }

    public ColorPaletteLoader(PApplet parent, String folderPath, String folderName) {
        super(parent, folderPath, folderName);
        this.type = 6;
        this.filePaths = this.loadPaths(this.type);
        this.palettes = new ColorPalette[this.filePaths.length];
    }

    @Override
    public ColorPaletteLoader update() {
        super.update();
        this.fileIndex = 0;
        this.filePaths = this.loadPaths(this.type);
        this.palettes = new ColorPalette[this.filePaths.length];
        return this;
    }

    @Override
    public ColorPaletteLoader resetKeySettings() {
        return (ColorPaletteLoader)super.resetKeySettings();
    }

    @Override
    public ColorPaletteLoader disableKeys() {
        return (ColorPaletteLoader)super.disableKeys();
    }

    @Override
    public ColorPaletteLoader enableKeys() {
        return (ColorPaletteLoader)super.enableKeys();
    }

    @Override
    public DataLoader setKey(String which, int keyCode) {
        return (ColorPaletteLoader)super.setKey(which, keyCode);
    }

    @Override
    public ColorPaletteLoader setKey(String which, char key) {
        return (ColorPaletteLoader)super.setKey(which, key);
    }

    @Override
    public ColorPalette loadFile(int index) {
        ColorPalette palette;
        index = RMath.constrain(index, 0, this.filePaths.length);
        String json = StringTools.join(this.parent.loadStrings(this.filePaths[index]), " ");
        this.palettes[index] = palette = new ColorPalette(json);
        return palette;
    }

    public ColorPalette[] loadAllFiles() {
        int i = 0;
        while (i < this.palettes.length) {
            if (this.palettes[i] == null) {
                this.loadFile(i);
            }
            ++i;
        }
        return this.palettes;
    }

    @Override
    public ColorPalette nextRandom() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = RMath.random(0, this.filePaths.length);
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPalette previous() {
        if (this.filePaths.length == 0) {
            return null;
        }
        int n = this.fileIndex = --this.fileIndex >= 0 ? this.fileIndex : this.filePaths.length - 1;
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPalette next() {
        if (this.filePaths.length == 0) {
            return null;
        }
        int n = this.fileIndex = ++this.fileIndex < this.filePaths.length ? this.fileIndex : 0;
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPalette first() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = 0;
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPalette last() {
        if (this.filePaths.length == 0) {
            return null;
        }
        this.fileIndex = this.filePaths.length - 1;
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        this.informObservers();
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPaletteLoader setIndex(int index) {
        super.setIndex(index);
        this.informObservers();
        return this;
    }

    @Override
    public ColorPaletteLoader setIndex(String filename) {
        super.setIndex(filename);
        this.informObservers();
        return this;
    }

    @Override
    public ColorPalette getCurrent() {
        if (this.palettes[this.fileIndex] == null) {
            this.loadFile(this.fileIndex);
        }
        return this.palettes[this.fileIndex];
    }

    @Override
    public ColorPalette get(int index) {
        if (this.palettes[index = RMath.constrain(index, 0, this.filePaths.length).intValue()] == null) {
            this.loadFile(index);
        }
        return this.palettes[index];
    }

    public ColorPaletteLoader addObserver(ColorPaletteUpdateObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public ColorPaletteLoader removeObserver(ColorPaletteUpdateObserver observer) {
        this.observers.remove(observer);
        return this;
    }

    public ColorPaletteLoader clearObservers() {
        this.observers.clear();
        return this;
    }

    private void informObservers() {
        for (ColorPaletteUpdateObserver o : this.observers) {
            o.setColorPalette(this.getCurrent());
        }
    }
}

