/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import net.returnvoid.graphics.shape.Line;
import net.returnvoid.graphics.shape.LineSegments;
import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PVector;

public class Rect
implements RShape {
    private PVector[] coordinates;
    protected PApplet parent;
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private Rect boundingBox = null;

    private Rect(PApplet parent) {
        this.parent = parent;
    }

    public Rect(PApplet parent, float x, float y, float width, float height) {
        this.parent = parent;
        this.minX = Float.valueOf(x);
        this.minY = Float.valueOf(y);
        this.maxX = Float.valueOf(x + width);
        this.maxY = Float.valueOf(y + height);
        this.coordinates = new PVector[]{new PVector(this.minX.floatValue(), this.minY.floatValue()), new PVector(this.maxX.floatValue(), this.minY.floatValue()), new PVector(this.maxX.floatValue(), this.maxY.floatValue()), new PVector(this.minX.floatValue(), this.maxY.floatValue())};
    }

    public Rect(PApplet parent, PVector p, PVector dimension) {
        this.parent = parent;
        this.minX = Float.valueOf(p.x);
        this.minY = Float.valueOf(p.y);
        this.maxX = Float.valueOf(p.x + dimension.x);
        this.maxY = Float.valueOf(p.x + dimension.y);
        this.coordinates = new PVector[]{new PVector(this.minX.floatValue(), this.minY.floatValue()), new PVector(this.maxX.floatValue(), this.minY.floatValue()), new PVector(this.maxX.floatValue(), this.maxY.floatValue()), new PVector(this.minX.floatValue(), this.maxY.floatValue())};
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public PVector get(int i) {
        return this.coordinates[i];
    }

    @Override
    public PVector getStart() {
        return this.coordinates[0];
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.coordinates[0].x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.coordinates[0].y);
    }

    public float getWidth() {
        return this.coordinates[0].dist(this.coordinates[1]);
    }

    public float getHeight() {
        return this.coordinates[1].dist(this.coordinates[2]);
    }

    public float getArea() {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public PVector[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public Float getRotation() {
        return Float.valueOf(PApplet.atan2((float)(this.coordinates[1].y - this.coordinates[0].y), (float)(this.coordinates[1].x - this.coordinates[0].x)));
    }

    @Override
    public Rect copy() {
        Rect copyRect = new Rect(this.parent);
        PVector[] copyCoordinates = new PVector[]{new PVector(this.coordinates[0].x, this.coordinates[0].y), new PVector(this.coordinates[1].x, this.coordinates[1].y), new PVector(this.coordinates[2].x, this.coordinates[2].y), new PVector(this.coordinates[3].x, this.coordinates[3].y)};
        copyRect.coordinates = copyCoordinates;
        return copyRect;
    }

    @Override
    public Rect setRotation(float angle) {
        return this.rotate(this.coordinates[0], angle - this.getRotation().floatValue());
    }

    @Override
    public Rect setRotation(PVector rotationCenter, float angle) {
        return this.rotate(rotationCenter, angle - this.getRotation().floatValue());
    }

    public Rect setDimension(float width, float height) {
        return this.scale(this.coordinates[0], width / this.getWidth(), height / this.getHeight());
    }

    public Rect setDimension(PVector center, float width, float height) {
        return this.scale(center, width / this.getWidth(), height / this.getHeight());
    }

    public Rect setWidth(float width) {
        return this.setWidth(this.getStart(), width);
    }

    public Rect setWidth(PVector center, float width) {
        return this.scale(center, width / this.getWidth(), 1.0f);
    }

    public Rect setHeight(float height) {
        return this.scale(this.coordinates[0], 1.0f, height / this.getHeight());
    }

    public Rect setHeight(PVector center, float height) {
        return this.scale(center, 1.0f, height / this.getHeight());
    }

    @Override
    public Rect setX(float x) {
        return this.translate(x - this.getCenter().x + this.getWidth() * 0.5f, 0.0f);
    }

    @Override
    public Rect setY(float y) {
        return this.translate(0.0f, y - this.getCenter().y + this.getHeight() * 0.5f);
    }

    @Override
    public Rect setLocation(float x, float y) {
        return this.translate(x - this.getCenter().x + this.getWidth() * 0.5f, y - this.getCenter().y + this.getHeight() * 0.5f);
    }

    @Override
    public Rect translate(float x, float y) {
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            p.x += x;
            p.y += y;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Rect rotate(float angle) {
        return this.rotate(this.coordinates[0], angle);
    }

    @Override
    public Rect rotate(PVector rotationCenter, float angle) {
        PVector center = rotationCenter;
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            float a = angle + PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
            float d = center.dist(p);
            p.x = center.x + PApplet.cos((float)a) * d;
            p.y = center.y + PApplet.sin((float)a) * d;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Rect scale(float scale) {
        return this.scale(this.coordinates[0], scale, scale);
    }

    @Override
    public Rect scale(PVector scaleCenter, float scale) {
        return this.scale(scaleCenter, scale, scale);
    }

    public Rect scale(PVector scaleCenter, float scaleX, float scaleY) {
        if ((double)RMath.abs(scaleX) > 0.01 && (double)RMath.abs(scaleY) > 0.01) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                return this;
            }
            PVector center = scaleCenter;
            float rotation = this.getRotation().floatValue();
            if (rotation != 0.0f) {
                this.setRotation(0.0f);
            }
            int i = 0;
            while (i < this.coordinates.length) {
                PVector p = this.coordinates[i];
                float a = PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                float dis = center.dist(p);
                float dx = dis * scaleX;
                float dy = dis * scaleY;
                p.x = center.x + PApplet.cos((float)a) * dx;
                p.y = center.y + PApplet.sin((float)a) * dy;
                ++i;
            }
            this.minX = null;
            this.boundingBox = null;
            if (rotation != 0.0f) {
                this.setRotation(rotation);
            }
        }
        return this;
    }

    public void computeMinMax() {
        float[] vals = RMath.range(this.coordinates);
        this.minX = Float.valueOf(vals[0]);
        this.maxX = Float.valueOf(vals[2]);
        this.minY = Float.valueOf(vals[1]);
        this.maxY = Float.valueOf(vals[3]);
    }

    @Override
    public Rect draw() {
        this.parent.beginShape(17);
        this.parent.vertex(this.coordinates[0].x, this.coordinates[0].y);
        this.parent.vertex(this.coordinates[1].x, this.coordinates[1].y);
        this.parent.vertex(this.coordinates[2].x, this.coordinates[2].y);
        this.parent.vertex(this.coordinates[3].x, this.coordinates[3].y);
        this.parent.endShape();
        return this;
    }

    public Line[] toLines() {
        PVector[] org = this.copy().coordinates;
        PVector[] coordCopy = new PVector[this.coordinates.length + 1];
        coordCopy[0] = org[0].copy();
        coordCopy[1] = org[1].copy();
        coordCopy[2] = org[2].copy();
        coordCopy[3] = org[3].copy();
        coordCopy[4] = org[0].copy();
        return Line.toLines(this.parent, coordCopy);
    }

    public Line[] getLines() {
        PVector[] coordCopy = new PVector[]{this.coordinates[0], this.coordinates[1], this.coordinates[2], this.coordinates[3], this.coordinates[0].copy()};
        return Line.toLines(this.parent, coordCopy);
    }

    public LineSegments toLineSegments() {
        PVector[] org = this.copy().coordinates;
        PVector[] coordCopy = new PVector[this.coordinates.length + 1];
        coordCopy[0] = org[0].copy();
        coordCopy[1] = org[1].copy();
        coordCopy[2] = org[2].copy();
        coordCopy[3] = org[3].copy();
        coordCopy[4] = org[0].copy();
        return new LineSegments(this.parent, coordCopy);
    }

    public LineSegments getLineSegments() {
        PVector[] org = this.copy().coordinates;
        PVector[] coordCopy = new PVector[this.coordinates.length + 1];
        coordCopy[0] = org[0];
        coordCopy[1] = org[1];
        coordCopy[2] = org[2];
        coordCopy[3] = org[3];
        coordCopy[4] = org[0].copy();
        return new LineSegments(this.parent, coordCopy);
    }
}

