/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import java.util.ArrayList;
import net.returnvoid.graphics.shape.Curve;
import net.returnvoid.graphics.shape.Line;
import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.graphics.shape.Rect;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PVector;

public class LineSegments
implements RShape {
    private PVector[] coordinates;
    protected PApplet parent;
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private Rect boundingBox = null;

    private LineSegments(PApplet parent) {
        this.parent = parent;
    }

    public LineSegments(PApplet parent, PVector[] coordinates) {
        if (coordinates.length < 2) {
            System.err.println("You can't build a LineSegments with less than 2 points");
        }
        this.parent = parent;
        this.coordinates = coordinates;
    }

    public LineSegments(PApplet parent, ArrayList<PVector> coordinates) {
        if (coordinates.size() < 2) {
            System.err.println("You can't build a LineSegments with less than 2 points");
        }
        this.parent = parent;
        this.coordinates = new PVector[coordinates.size()];
        int i = 0;
        while (i < coordinates.size()) {
            this.coordinates[i] = coordinates.get(i);
            ++i;
        }
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    public int lineSize() {
        return this.coordinates.length - 1;
    }

    @Override
    public PVector get(int i) {
        return this.coordinates[i];
    }

    public Line getLine(int i) {
        return new Line(this.parent, this.coordinates[i], this.coordinates[i + 1]);
    }

    @Override
    public PVector getStart() {
        return this.coordinates[0];
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.getStart().x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.getStart().y);
    }

    public PVector getEnd() {
        return this.coordinates[this.coordinates.length - 1];
    }

    public float getLength() {
        return PVector.dist((PVector)this.getStart(), (PVector)this.getEnd());
    }

    @Override
    public PVector[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    public float getArcLength() {
        float length = 0.0f;
        int i = 1;
        while (i < this.coordinates.length) {
            length += this.coordinates[i - 1].dist(this.coordinates[i]);
            ++i;
        }
        return length;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public LineSegments copy() {
        LineSegments copySeg = new LineSegments(this.parent);
        copySeg.coordinates = new PVector[this.coordinates.length];
        int i = 0;
        while (i < this.coordinates.length) {
            copySeg.coordinates[i] = new PVector(this.coordinates[i].x, this.coordinates[i].y);
            ++i;
        }
        return copySeg;
    }

    @Override
    public Float getRotation() {
        return Float.valueOf(PApplet.atan2((float)(this.getEnd().y - this.getStart().y), (float)(this.getEnd().x - this.getStart().x)));
    }

    @Override
    public LineSegments setRotation(float angle) {
        return this.rotate(this.coordinates[0], angle - this.getRotation().floatValue());
    }

    @Override
    public LineSegments setRotation(PVector rotationCenter, float angle) {
        return this.rotate(rotationCenter, angle - this.getRotation().floatValue());
    }

    public LineSegments setLength(float length) {
        return this.scale(this.coordinates[0], length / this.getLength(), 1.0f);
    }

    public LineSegments setLength(PVector center, float length) {
        return this.scale(center, length / this.getLength());
    }

    public LineSegments set(int i, PVector p) {
        this.minX = null;
        this.boundingBox = null;
        this.coordinates[i] = p;
        return this;
    }

    public LineSegments set(int i, float x, float y) {
        this.coordinates[i].x = x;
        this.coordinates[i].y = y;
        return this;
    }

    @Override
    public LineSegments setX(float x) {
        return this.translate(x - this.getX().floatValue(), 0.0f);
    }

    @Override
    public LineSegments setY(float y) {
        return this.translate(0.0f, y - this.getY().floatValue());
    }

    @Override
    public LineSegments setLocation(float x, float y) {
        return this.translate(x - this.getX().floatValue(), y - this.getY().floatValue());
    }

    @Override
    public LineSegments translate(float x, float y) {
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            p.x += x;
            p.y += y;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public LineSegments rotate(float angle) {
        return this.rotate(this.coordinates[0], angle);
    }

    @Override
    public LineSegments rotate(PVector rotationCenter, float angle) {
        PVector center = rotationCenter;
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            float a = angle + PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
            float d = center.dist(p);
            p.x = center.x + PApplet.cos((float)a) * d;
            p.y = center.y + PApplet.sin((float)a) * d;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public LineSegments scale(float scale) {
        return this.scale(this.coordinates[0], scale, scale);
    }

    @Override
    public LineSegments scale(PVector scaleCenter, float scale) {
        return this.scale(scaleCenter, scale, scale);
    }

    public LineSegments scale(PVector scaleCenter, float scaleX, float scaleY) {
        if ((double)RMath.abs(scaleX) > 0.01 && (double)RMath.abs(scaleY) > 0.01) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                return this;
            }
            PVector center = scaleCenter;
            float rotation = this.getRotation().floatValue();
            if (rotation != 0.0f) {
                this.setRotation(0.0f);
            }
            int i = 0;
            while (i < this.coordinates.length) {
                PVector p = this.coordinates[i];
                float a = PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                float dis = center.dist(p);
                float dx = dis * scaleX;
                float dy = dis * scaleY;
                p.x = center.x + PApplet.cos((float)a) * dx;
                p.y = center.y + PApplet.sin((float)a) * dy;
                ++i;
            }
            this.minX = null;
            this.boundingBox = null;
            if (rotation != 0.0f) {
                this.setRotation(rotation);
            }
        }
        return this;
    }

    public void computeMinMax() {
        float[] vals = RMath.range(this.coordinates);
        this.minX = Float.valueOf(vals[0]);
        this.maxX = Float.valueOf(vals[2]);
        this.minY = Float.valueOf(vals[1]);
        this.maxY = Float.valueOf(vals[3]);
    }

    public void removeIntersectingLines(ArrayList<Line> toRemove) {
        this.removeIntersectingLines(toRemove, false);
    }

    public void removeIntersectingLines(ArrayList<Line> toRemove, boolean ignoreStartEnd) {
        int i = 0;
        while (i < this.lineSize()) {
            Line l = this.getLine(i);
            int j = 0;
            while (j < toRemove.size()) {
                if (l.hasIntersection(toRemove.get(j), ignoreStartEnd)) {
                    toRemove.remove(j);
                    --j;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public LineSegments draw() {
        this.parent.beginShape();
        PVector[] pVectorArray = this.coordinates;
        int n = this.coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            PVector p = pVectorArray[n2];
            this.parent.vertex(p.x, p.y);
            ++n2;
        }
        this.parent.endShape();
        return this;
    }

    public Curve toCurve() {
        PVector[] copyCoordinates = new PVector[this.coordinates.length];
        int i = 0;
        while (i < this.coordinates.length) {
            copyCoordinates[i] = new PVector(this.coordinates[i].x, this.coordinates[i].y);
            ++i;
        }
        return new Curve(this.parent, copyCoordinates);
    }

    public Curve getCurve() {
        return new Curve(this.parent, this.coordinates);
    }

    public Line toLine() {
        return new Line(this.parent, new PVector(this.getStart().x, this.getStart().y), new PVector(this.getEnd().x, this.getEnd().y));
    }

    public Line getLine() {
        return new Line(this.parent, this.getStart(), this.getEnd());
    }

    public Line[] toLines() {
        return Line.toLines(this.parent, this.copy().coordinates);
    }

    public Line[] getLines() {
        return Line.toLines(this.parent, this.coordinates);
    }
}

