/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import java.util.ArrayList;
import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.graphics.shape.Rect;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PVector;

public class Line
implements RShape {
    private PVector[] coordinates;
    protected PApplet parent;
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private Rect boundingBox = null;

    private Line(PApplet parent) {
        this.parent = parent;
    }

    public Line(PApplet parent, PVector start, PVector end) {
        this.parent = parent;
        this.coordinates = new PVector[2];
        this.coordinates[0] = start;
        this.coordinates[1] = end;
    }

    public Line(PApplet parent, float startX, float startY, float endX, float endY) {
        this(parent, new PVector(startX, startY), new PVector(endX, endY));
    }

    public Line(PApplet parent, PVector start, float angle, float length) {
        this(parent, start, new PVector((float)((double)start.x + Math.cos(angle) * (double)length), (float)((double)start.y + Math.sin(angle) * (double)length)));
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public PVector get(int i) {
        return i == 0 ? this.getStart() : this.getEnd();
    }

    @Override
    public PVector getStart() {
        return this.coordinates[0];
    }

    public PVector getEnd() {
        return this.coordinates[1];
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.getStart().x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.getStart().y);
    }

    public float getLength() {
        return this.getStart().dist(this.getEnd());
    }

    @Override
    public PVector[] getCoordinates() {
        return this.coordinates;
    }

    public PVector getNormal() {
        return Line.getNormal(this.getStart(), this.getEnd());
    }

    public Line getNormalLine(float lineLength) {
        PVector normalCopy = this.getNormal();
        normalCopy.normalize();
        normalCopy.mult(lineLength);
        Line line = new Line(this.parent, normalCopy.x + PApplet.lerp((float)this.getStart().x, (float)this.getEnd().x, (float)0.5f), normalCopy.y + PApplet.lerp((float)this.getStart().y, (float)this.getEnd().y, (float)0.5f), PApplet.lerp((float)this.getStart().x, (float)this.getEnd().x, (float)0.5f), PApplet.lerp((float)this.getStart().y, (float)this.getEnd().y, (float)0.5f));
        return line;
    }

    @Override
    public Float getRotation() {
        return Float.valueOf(PApplet.atan2((float)(this.getEnd().y - this.getStart().y), (float)(this.getEnd().x - this.getStart().x)));
    }

    @Override
    public Line copy() {
        Line copyLine = new Line(this.parent);
        PVector[] copyCoordinates = new PVector[]{new PVector(this.coordinates[0].x, this.coordinates[0].y), new PVector(this.coordinates[1].x, this.coordinates[1].y)};
        copyLine.coordinates = copyCoordinates;
        return copyLine;
    }

    @Override
    public Line setRotation(float angle) {
        return this.rotate(this.coordinates[0], angle - this.getRotation().floatValue());
    }

    @Override
    public Line setRotation(PVector rotationCenter, float angle) {
        return this.rotate(rotationCenter, angle - this.getRotation().floatValue());
    }

    public Line setLength(float length) {
        return this.scale(this.coordinates[0], length / this.getLength());
    }

    public Line setLength(PVector center, float length) {
        return this.scale(center, length / this.getLength());
    }

    @Override
    public Line setX(float x) {
        return this.translate(x - this.getCenter().x + this.getLength() * 0.5f, 0.0f);
    }

    @Override
    public Line setY(float y) {
        return this.translate(0.0f, y - this.getCenter().y + this.getLength() * 0.5f);
    }

    @Override
    public Line setLocation(float x, float y) {
        return this.translate(x - this.getCenter().x + this.getLength() * 0.5f, y - this.getCenter().y + this.getLength() * 0.5f);
    }

    public PVector intersection(Line other) {
        return Line.intersection(this, other, false);
    }

    public PVector intersection(Line other, boolean ignoreStartEnd) {
        return Line.intersection(this, other, ignoreStartEnd);
    }

    public boolean hasIntersection(Line other) {
        return this.hasIntersection(other, false);
    }

    public boolean hasIntersection(Line other, boolean ignoreStartEnd) {
        PVector sec = this.intersection(other, ignoreStartEnd);
        return sec != null;
    }

    @Override
    public Line translate(float x, float y) {
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            p.x += x;
            p.y += y;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Line rotate(float angle) {
        return this.rotate(this.coordinates[0], angle);
    }

    @Override
    public Line rotate(PVector rotationCenter, float angle) {
        PVector center = rotationCenter;
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            float a = angle + PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
            float d = center.dist(p);
            p.x = center.x + PApplet.cos((float)a) * d;
            p.y = center.y + PApplet.sin((float)a) * d;
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Line scale(float scale) {
        return this.scale(this.coordinates[0], scale);
    }

    @Override
    public Line scale(PVector scaleCenter, float scale) {
        if ((double)RMath.abs(scale) > 0.01) {
            PVector center = scaleCenter;
            float rotation = this.getRotation().floatValue();
            if (rotation != 0.0f) {
                this.setRotation(0.0f);
            }
            int i = 0;
            while (i < this.coordinates.length) {
                PVector p = this.coordinates[i];
                float a = PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                float dis = center.dist(p);
                float d = dis * scale;
                p.x = center.x + PApplet.cos((float)a) * d;
                p.y = center.y + PApplet.sin((float)a) * d;
                ++i;
            }
            this.minX = null;
            this.boundingBox = null;
            if (rotation != 0.0f) {
                this.setRotation(rotation);
            }
            this.minX = null;
            this.boundingBox = null;
        }
        return this;
    }

    public void computeMinMax() {
        float[] vals = RMath.range(this.coordinates);
        this.minX = Float.valueOf(vals[0]);
        this.maxX = Float.valueOf(vals[2]);
        this.minY = Float.valueOf(vals[1]);
        this.maxY = Float.valueOf(vals[3]);
    }

    public static PVector getNormal(PVector p, PVector o) {
        return new PVector(o.y - p.y, p.x - o.x);
    }

    public static Line[] toLines(PApplet parent, PVector[] points) {
        Line[] lines = new Line[points.length - 1];
        int i = 1;
        while (i < points.length) {
            lines[i - 1] = new Line(parent, points[i - 1], points[i]);
            ++i;
        }
        return lines;
    }

    public static PVector intersection(Line base, Line other) {
        return Line.intersection(base, other, false);
    }

    public static PVector intersection(Line base, Line other, boolean ignoreStartEnd) {
        Line line1 = base;
        PVector start1 = line1.getStart();
        PVector dir1 = line1.toRotationVector();
        float l1 = line1.getLength();
        Line line2 = other;
        PVector start2 = line2.getStart();
        PVector dir2 = line2.toRotationVector();
        float l2 = line2.getLength();
        double skalar2 = ((double)start2.y * (double)dir1.x - (double)(start1.y * dir1.x) - (double)(dir1.y * start2.x) + (double)(start1.x * dir1.y)) / (double)(dir2.x * dir1.y - dir2.y * dir1.x);
        double skalar1 = ((double)start2.x + skalar2 * (double)dir2.x - (double)start1.x) / (double)dir1.x;
        if (Double.isInfinite(skalar2) || Double.isInfinite(skalar1)) {
            float lefty2;
            float x1 = 0.0f;
            float y1 = 0.0f;
            float leftx1 = RMath.min(line1.getStart().x, line1.getEnd().x);
            float lefty1 = leftx1 == line1.getStart().x ? line1.getStart().y : line1.getEnd().y;
            float leftx2 = RMath.min(line2.getStart().x, line2.getEnd().x);
            float f = lefty2 = leftx2 == line2.getStart().x ? line2.getStart().y : line2.getEnd().y;
            if (leftx1 > leftx2 || leftx1 == leftx2) {
                x1 = leftx1;
                y1 = lefty1;
            } else if (leftx1 < leftx2) {
                x1 = leftx2;
                y1 = lefty2;
            } else {
                float topx2;
                float topy1 = RMath.min(line1.getStart().y, line1.getEnd().y);
                float topy2 = RMath.min(line2.getStart().y, line2.getEnd().y);
                float topx1 = topy1 == line1.getStart().y ? line1.getStart().x : line1.getEnd().x;
                float f2 = topx2 = topy2 == line2.getStart().y ? line2.getStart().x : line2.getEnd().x;
                if (topy1 > topy2 || topy1 == topy2) {
                    x1 = topx1;
                    y1 = topy1;
                } else if (topy1 < topy2) {
                    x1 = topx2;
                    y1 = topy2;
                } else {
                    x1 = topx1;
                    y1 = topy1;
                }
            }
            return new PVector(x1, y1);
        }
        if (Double.isNaN(skalar2) || Double.isNaN(skalar1)) {
            return null;
        }
        if (skalar1 < 0.0 || skalar2 < 0.0) {
            return null;
        }
        PVector crossed = dir1;
        crossed.mult((float)skalar1);
        crossed.add(start1);
        if (ignoreStartEnd && (crossed.dist(start1) < 1.0f || crossed.dist(start2) < 1.0f || crossed.dist(line1.getEnd()) < 1.0f || crossed.dist(line2.getEnd()) < 1.0f)) {
            return null;
        }
        if (crossed.dist(start1) > l1 || crossed.dist(start2) > l2) {
            return null;
        }
        return crossed;
    }

    public static boolean hasIntersection(Line base, Line other) {
        return Line.hasIntersection(base, other, false);
    }

    public static boolean hasIntersection(Line base, Line other, boolean ignoreStartEnd) {
        PVector sec = Line.intersection(base, other, ignoreStartEnd);
        return sec != null;
    }

    public static void removeIntersectingLines(ArrayList<Line> lines) {
        Line.removeIntersectingLines(lines, false);
    }

    public static void removeIntersectingLines(ArrayList<Line> lines, boolean ignoreStartEnd) {
        int i = 0;
        while (i < lines.size()) {
            int j = i + 1;
            while (j < lines.size()) {
                PVector cross = Line.intersection(lines.get(i), lines.get(j), ignoreStartEnd);
                if (cross != null) {
                    lines.remove(lines.get(j));
                    --j;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void removeIntersectingLinesHierarchical(ArrayList<Line> lines) {
        Line.removeIntersectingLinesHierarchical(lines, false);
    }

    public static void removeIntersectingLinesHierarchical(ArrayList<Line> lines, boolean ignoreStartEnd) {
        boolean intersectionFound = true;
        while (intersectionFound) {
            intersectionFound = false;
            int[] intersections = new int[lines.size()];
            int i = 0;
            while (i < lines.size()) {
                intersections[i] = 0;
                int k = 0;
                while (k < lines.size()) {
                    if (i != k && Line.hasIntersection(lines.get(i), lines.get(k), ignoreStartEnd)) {
                        int n = i;
                        intersections[n] = intersections[n] + 1;
                        intersectionFound = true;
                    }
                    ++k;
                }
                ++i;
            }
            if (!intersectionFound) continue;
            int maxID = 0;
            int maxIntersec = 0;
            ArrayList<Integer> indexesWithSameNumberOfIntersections = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < intersections.length) {
                if (intersections[i2] > maxIntersec) {
                    indexesWithSameNumberOfIntersections.clear();
                    maxID = i2;
                    maxIntersec = intersections[i2];
                    indexesWithSameNumberOfIntersections.add(i2);
                } else if (intersections[i2] == maxIntersec) {
                    indexesWithSameNumberOfIntersections.add(i2);
                }
                ++i2;
            }
            if (indexesWithSameNumberOfIntersections.size() > 1) {
                int index = (Integer)indexesWithSameNumberOfIntersections.get(indexesWithSameNumberOfIntersections.size() / 2);
                lines.remove(index);
                continue;
            }
            lines.remove(maxID);
        }
    }

    @Override
    public Line draw() {
        this.parent.line(this.getStart().x, this.getStart().y, this.getEnd().x, this.getEnd().y);
        return this;
    }

    public PVector toRotationVector() {
        float angle = this.getRotation().floatValue();
        return new PVector(PApplet.cos((float)angle), PApplet.sin((float)angle));
    }
}

