/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.graphics.shape.Rect;
import processing.core.PApplet;
import processing.core.PVector;

public class Ellipse
implements RShape {
    private Rect rect;
    protected PApplet parent;
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private Rect boundingBox = null;

    public Ellipse(PApplet parent, PVector[] coordinates) {
        this.parent = parent;
        this.rect = new Rect(parent, 0.0f, 0.0f, 0.0f, 0.0f);
        this.rect.getCoordinates()[0] = coordinates[0];
        this.rect.getCoordinates()[1] = coordinates[1];
        this.rect.getCoordinates()[2] = coordinates[2];
        this.rect.getCoordinates()[3] = coordinates[3];
        this.rect.computeMinMax();
    }

    public Ellipse(PApplet parent, float x, float y, float width, float height) {
        this.parent = parent;
        this.rect = new Rect(parent, x - width * 0.5f, y - height * 0.5f, width, height);
    }

    public Ellipse(PApplet parent, PVector p, PVector dimension) {
        this.parent = parent;
        PVector loc = new PVector(p.x - dimension.x * 0.5f, p.y - dimension.y * 0.5f);
        this.rect = new Rect(parent, loc, dimension);
    }

    @Override
    public int size() {
        return this.rect.size();
    }

    @Override
    public PVector get(int i) {
        return this.rect.get(i);
    }

    @Override
    public PVector getStart() {
        return this.rect.getStart();
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.getStart().x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.getStart().y);
    }

    public float getWidth() {
        return this.rect.getWidth();
    }

    public float getHeight() {
        return this.rect.getHeight();
    }

    public float getArea() {
        return 1.5707964f * this.getWidth() * 0.5f * this.getHeight();
    }

    @Override
    public PVector[] getCoordinates() {
        return this.rect.getCoordinates();
    }

    @Override
    public Float getRotation() {
        return this.rect.getRotation();
    }

    @Override
    public Ellipse copy() {
        PVector[] copyCoordinates = new PVector[]{new PVector(this.get((int)0).x, this.get((int)0).y), new PVector(this.get((int)1).x, this.get((int)1).y), new PVector(this.get((int)2).x, this.get((int)2).y), new PVector(this.get((int)3).x, this.get((int)3).y)};
        return new Ellipse(this.parent, copyCoordinates);
    }

    @Override
    public Ellipse setRotation(float angle) {
        this.rect.rotate(this.getStart(), angle - this.getRotation().floatValue());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse setRotation(PVector rotationCenter, float angle) {
        this.rect.rotate(rotationCenter, angle - this.getRotation().floatValue());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setDimension(float width, float height) {
        this.rect.scale(this.getStart(), width / this.getWidth(), height / this.getHeight());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setDimension(PVector center, float width, float height) {
        this.rect.scale(center, width / this.getWidth(), height / this.getHeight());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setWidth(float width) {
        this.rect.scale(this.getStart(), width / this.getWidth(), 1.0f);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setWidth(PVector center, float width) {
        this.rect.scale(center, width / this.getWidth(), 1.0f);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setHeight(float height) {
        this.rect.scale(this.getStart(), 1.0f, height / this.getHeight());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse setHeight(PVector center, float height) {
        this.rect.scale(center, 1.0f, height / this.getHeight());
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse setX(float x) {
        this.rect.setX(x - this.getBoundingBox().getWidth() * 0.5f);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse setY(float y) {
        this.rect.setY(y - this.getBoundingBox().getHeight() * 0.5f);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse setLocation(float x, float y) {
        this.rect.setLocation(x, y);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse translate(float x, float y) {
        this.rect.translate(x, y);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse rotate(float angle) {
        this.rect.rotate(this.getStart(), angle);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse rotate(PVector rotationCenter, float angle) {
        this.rect.rotate(rotationCenter, angle);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse scale(float scale) {
        this.rect.scale(this.getStart(), scale, scale);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    @Override
    public Ellipse scale(PVector scaleCenter, float scale) {
        this.rect.scale(scaleCenter, scale, scale);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public Ellipse scale(PVector scaleCenter, float scaleX, float scaleY) {
        this.rect.scale(scaleCenter, scaleX, scaleY);
        this.boundingBox = null;
        this.minX = null;
        return this;
    }

    public void computeMinMax() {
        PVector p = this.rect.getCenter();
        float a = this.getRotation().floatValue();
        float r1 = this.getWidth() / 2.0f;
        float r2 = this.getHeight() / 2.0f;
        double cc = Math.pow(PApplet.cos((float)a), 2.0);
        double ss = Math.pow(PApplet.sin((float)a), 2.0);
        double r1r1 = Math.pow(r1, 2.0);
        double r2r2 = Math.pow(r2, 2.0);
        float x = (float)Math.pow(r1r1 * cc + r2r2 * ss, 0.5);
        float y = (float)Math.pow(r1r1 * ss + r2r2 * cc, 0.5);
        this.minX = Float.valueOf(p.x - x);
        this.maxX = Float.valueOf(p.x + x);
        this.minY = Float.valueOf(p.y - y);
        this.maxY = Float.valueOf(p.y + y);
    }

    @Override
    public Ellipse draw() {
        float angle = this.getRotation().floatValue();
        PVector center = this.getCenter();
        if (angle != 0.0f) {
            this.parent.pushMatrix();
            this.parent.translate(center.x, center.y);
            this.parent.rotate(angle);
            this.parent.ellipse(0.0f, 0.0f, this.getWidth(), this.getHeight());
            this.parent.popMatrix();
        } else {
            this.parent.ellipse(center.x, center.y, this.getWidth(), this.getHeight());
        }
        return this;
    }
}

