/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import java.util.ArrayList;
import net.returnvoid.graphics.shape.Curve;
import net.returnvoid.graphics.shape.Line;
import net.returnvoid.graphics.shape.LineSegments;
import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.graphics.shape.Rect;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PVector;

public class CurvedLens
implements RShape {
    private LineSegments centerCooridates;
    private float height;
    protected PApplet parent;
    private PVector[] coordinates;
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private float detailScale;
    private Rect boundingBox = null;

    private CurvedLens(PApplet parent) {
        this.parent = parent;
    }

    public CurvedLens(PApplet parent, PVector[] coordinates, float height) {
        if (coordinates.length < 2) {
            System.err.println("You can't build a lens with less than 2 points");
        }
        this.parent = parent;
        this.detailScale = 1.0f;
        this.centerCooridates = new LineSegments(parent, coordinates);
        this.height = height / 2.0f;
        this.coordinates = null;
        this.buildOutline();
    }

    public float getDetailScale() {
        return this.detailScale;
    }

    public int getDetails() {
        return (int)(this.detailScale * (float)this.centerCooridates.size());
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    public int centerSize() {
        return this.centerCooridates.size();
    }

    @Override
    public PVector get(int i) {
        return this.coordinates[i];
    }

    @Override
    public PVector getStart() {
        return this.centerCooridates.getStart();
    }

    public PVector getEnd() {
        return this.centerCooridates.getEnd();
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.getStart().x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.getStart().y);
    }

    public float getHeight() {
        return this.height * 2.0f;
    }

    public float getLength() {
        return this.centerCooridates.getLength();
    }

    public float getArea() {
        Curve curve = this.toSmoothedCurve();
        return (float)((double)(curve.getArcLength().floatValue() * this.getHeight()) * (1.0 - Math.cos(1.0)));
    }

    @Override
    public PVector[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public Float getRotation() {
        return this.centerCooridates.getRotation();
    }

    @Override
    public CurvedLens copy() {
        LineSegments segCopy = this.centerCooridates.copy();
        CurvedLens clCopy = new CurvedLens(this.parent);
        clCopy.centerCooridates = segCopy;
        clCopy.height = this.height;
        clCopy.detailScale = this.detailScale;
        clCopy.coordinates = new PVector[this.size()];
        PVector start = segCopy.getStart();
        PVector end = segCopy.getEnd();
        int i = 0;
        while (i < this.size()) {
            clCopy.coordinates[i] = this.get(i) == this.getStart() ? start : (this.get(i) == this.getEnd() ? end : new PVector(this.get((int)i).x, this.get((int)i).y));
            ++i;
        }
        return clCopy;
    }

    public CurvedLens setLength(float newLength) {
        return this.setLength(this.getStart(), newLength);
    }

    public CurvedLens setLength(PVector center, float newLength) {
        if (newLength > (float)(this.size() * 2)) {
            this.centerCooridates.setLength(center, newLength);
            this.buildOutline();
            return this;
        }
        return this;
    }

    public CurvedLens setHeight(float height) {
        if (height > 1.0f) {
            this.height = height / 2.0f;
            this.buildOutline();
        }
        return this;
    }

    @Override
    public CurvedLens setRotation(float angle) {
        return this.rotate(this.getStart(), angle - this.getRotation().floatValue());
    }

    @Override
    public CurvedLens setRotation(PVector rotationCenter, float angle) {
        return this.rotate(rotationCenter, angle - this.getRotation().floatValue());
    }

    @Override
    public CurvedLens setX(float x) {
        return this.translate(x - this.getX().floatValue(), 0.0f);
    }

    @Override
    public CurvedLens setY(float y) {
        return this.translate(0.0f, y - this.getY().floatValue());
    }

    @Override
    public CurvedLens setLocation(float x, float y) {
        return this.translate(x - this.getCenter().x + this.getBoundingBox().getWidth() * 0.5f, y - this.getCenter().y + this.getBoundingBox().getHeight() * 0.5f);
    }

    public CurvedLens setDetailScale(float detailScale) {
        if ((double)detailScale > 0.1 && (float)this.centerCooridates.size() * detailScale >= 3.0f) {
            this.detailScale = detailScale;
            this.buildOutline();
            return this;
        }
        return this;
    }

    public CurvedLens setDetails(int details) {
        this.detailScale = (float)details / (float)this.centerCooridates.size();
        this.buildOutline();
        return this;
    }

    public void computeMinMax() {
        float[] vals = RMath.range(this.coordinates);
        this.minX = Float.valueOf(vals[0]);
        this.maxX = Float.valueOf(vals[2]);
        this.minY = Float.valueOf(vals[1]);
        this.maxY = Float.valueOf(vals[3]);
    }

    public float computeHeight(float tplusi) {
        return PApplet.sin((float)RMath.constrain(RMath.map(tplusi, 0.0f, this.centerCooridates.size() - 1, 0.0f, (float)Math.PI), 0.0f, (float)Math.PI)) * this.height;
    }

    private float computeHeight(Curve curve, float tplusi) {
        return PApplet.sin((float)RMath.constrain(RMath.map(tplusi, 0.0f, curve.size() - 1, 0.0f, (float)Math.PI), 0.0f, (float)Math.PI)) * this.height;
    }

    private void buildOutline() {
        Curve curve = this.toSmoothedCurve();
        int s = curve.size();
        ArrayList<Line> l1 = new ArrayList<Line>(s);
        ArrayList<Line> l2 = new ArrayList<Line>(s);
        int i = 0;
        int j = 1;
        while (i < s - 1) {
            float tplusi = RMath.map(j, 0.0f, s - 1, 0.0f, curve.size() - 1);
            float[] normal = curve.getNormal(tplusi);
            float length = this.computeHeight(curve, tplusi);
            PVector start = new PVector(normal[0], normal[1]);
            PVector end1 = RMath.polarToCartesian(start, normal[2], length);
            PVector end2 = RMath.polarToCartesian(start, (float)(-Math.PI) + normal[2], length);
            Line line1 = new Line(this.parent, start, end1);
            Line line2 = new Line(this.parent, start, end2);
            l1.add(line1);
            l2.add(line2);
            ++i;
            ++j;
        }
        curve.removeIntersectingLines(l1, true);
        curve.removeIntersectingLines(l2, true);
        Line.removeIntersectingLinesHierarchical(l1, false);
        Line.removeIntersectingLinesHierarchical(l2, false);
        this.coordinates = new PVector[l1.size() + l2.size() + 6];
        this.coordinates[0] = this.centerCooridates.getStart();
        this.coordinates[1] = this.centerCooridates.getStart();
        int coordIndex = 2;
        int i2 = 0;
        while (i2 < l2.size()) {
            this.coordinates[coordIndex] = l2.get(i2).getEnd();
            ++i2;
            ++coordIndex;
        }
        this.coordinates[coordIndex] = this.centerCooridates.getEnd();
        this.coordinates[coordIndex + 1] = this.centerCooridates.getEnd();
        coordIndex += 2;
        i2 = l1.size() - 1;
        while (i2 >= 0) {
            this.coordinates[coordIndex] = l1.get(i2).getEnd();
            --i2;
            ++coordIndex;
        }
        this.coordinates[coordIndex] = this.centerCooridates.getStart();
        this.coordinates[coordIndex + 1] = this.centerCooridates.getStart();
        this.minX = null;
        this.boundingBox = null;
    }

    @Override
    public CurvedLens translate(float x, float y) {
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            if (p != this.getStart() && p != this.getEnd()) {
                p.x += x;
                p.y += y;
            }
            ++i;
        }
        this.centerCooridates.translate(x, y);
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public CurvedLens rotate(float angle) {
        return this.rotate(this.coordinates[0], angle);
    }

    @Override
    public CurvedLens rotate(PVector rotationCenter, float angle) {
        this.centerCooridates.rotate(rotationCenter, angle);
        PVector center = rotationCenter;
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            if (p != this.getStart() && p != this.getEnd()) {
                float a = angle + PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                float d = center.dist(p);
                p.x = center.x + PApplet.cos((float)a) * d;
                p.y = center.y + PApplet.sin((float)a) * d;
            }
            ++i;
        }
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public CurvedLens scale(float scale) {
        return this.scale(this.coordinates[0], scale, scale);
    }

    @Override
    public CurvedLens scale(PVector scaleCenter, float scale) {
        return this.scale(scaleCenter, scale, scale);
    }

    public CurvedLens scale(PVector scaleCenter, float scaleX, float scaleY) {
        if ((double)RMath.abs(scaleX) > 0.01 && (double)RMath.abs(scaleY) > 0.01) {
            this.centerCooridates.scale(scaleCenter, scaleX, scaleY);
            PVector center = this.getStart();
            float rotation = this.getRotation().floatValue();
            if (rotation != 0.0f) {
                this.setRotation(0.0f);
            }
            int i = 0;
            while (i < this.coordinates.length) {
                PVector p = this.coordinates[i];
                if (p != this.getStart() && p != this.getEnd()) {
                    float a = PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                    float dis = center.dist(p);
                    float dx = dis * scaleX;
                    float dy = dis * scaleY;
                    p.x = center.x + PApplet.cos((float)a) * dx;
                    p.y = center.y + PApplet.sin((float)a) * dy;
                }
                ++i;
            }
            this.minX = null;
            this.boundingBox = null;
            if (rotation != 0.0f) {
                this.setRotation(rotation);
            }
        }
        return this;
    }

    @Override
    public CurvedLens draw() {
        boolean endDrawn = false;
        this.parent.beginShape();
        PVector[] pVectorArray = this.coordinates;
        int n = this.coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            PVector p = pVectorArray[n2];
            this.parent.curveVertex(p.x, p.y);
            if (!endDrawn && p == this.centerCooridates.getEnd()) {
                this.parent.vertex(p.x, p.y);
                endDrawn = true;
            }
            ++n2;
        }
        this.parent.endShape();
        return this;
    }

    public CurvedLens drawRaw() {
        this.parent.beginShape();
        PVector[] pVectorArray = this.coordinates;
        int n = this.coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            PVector p = pVectorArray[n2];
            this.parent.vertex(p.x, p.y);
            ++n2;
        }
        this.parent.endShape();
        return this;
    }

    public CurvedLens drawCenter() {
        this.centerCooridates.draw();
        return this;
    }

    public Curve getCurve() {
        return this.centerCooridates.getCurve();
    }

    public Curve toCurve() {
        return this.centerCooridates.copy().getCurve();
    }

    public LineSegments getLineSegments() {
        return this.centerCooridates;
    }

    public LineSegments toLineSegments() {
        return this.centerCooridates.copy();
    }

    public Curve toSmoothedCurve() {
        return this.centerCooridates.getCurve().toSmoothedCurve(this.detailScale);
    }
}

