/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.shape;

import java.util.ArrayList;
import net.returnvoid.graphics.shape.Line;
import net.returnvoid.graphics.shape.LineSegments;
import net.returnvoid.graphics.shape.RShape;
import net.returnvoid.graphics.shape.Rect;
import net.returnvoid.tools.RMath;
import processing.core.PApplet;
import processing.core.PVector;

public class Curve
implements RShape {
    private PVector controlZero;
    private PVector controlLast;
    private PVector[] coordinates;
    private static float[][] curveBaseMatrix = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};
    private Float minX = null;
    private Float maxX = null;
    private Float minY = null;
    private Float maxY = null;
    private Rect boundingBox = null;
    private Float arcLength = null;
    private ArrayList<SegmentRange> ranges;
    protected PApplet parent;

    public Curve(PApplet parent) {
        this.parent = parent;
        this.ranges = new ArrayList();
    }

    public Curve(PApplet parent, PVector[] coordinates) {
        if (coordinates.length < 3) {
            System.err.println("You can't build a curve with less than 3 points");
        }
        this.parent = parent;
        this.coordinates = coordinates;
        this.computeControlZero();
        this.computeControlLast();
        this.ranges = new ArrayList();
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public PVector get(int i) {
        return this.coordinates[i];
    }

    @Override
    public PVector getStart() {
        return this.coordinates[0];
    }

    public PVector getEnd() {
        return this.coordinates[this.coordinates.length - 1];
    }

    public float getLength() {
        return this.getStart().dist(this.getEnd());
    }

    @Override
    public Rect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.minX == null) {
                this.computeMinMax();
            }
            this.boundingBox = new Rect(this.parent, this.minX.floatValue(), this.minY.floatValue(), this.maxX.floatValue() - this.minX.floatValue(), this.maxY.floatValue() - this.minY.floatValue());
        }
        return this.boundingBox;
    }

    @Override
    public PVector getCenter() {
        if (this.minX == null) {
            this.computeMinMax();
        }
        return new PVector(0.5f * (this.minX.floatValue() + this.maxX.floatValue()), 0.5f * (this.minY.floatValue() + this.maxY.floatValue()));
    }

    @Override
    public Float getX() {
        return Float.valueOf(this.getStart().x);
    }

    @Override
    public Float getY() {
        return Float.valueOf(this.getStart().y);
    }

    @Override
    public PVector[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public Float getRotation() {
        return Float.valueOf(PApplet.atan2((float)(this.getEnd().y - this.getStart().y), (float)(this.getEnd().x - this.getStart().x)));
    }

    @Override
    public Curve copy() {
        Curve copyCurve = new Curve(this.parent);
        copyCurve.coordinates = new PVector[this.coordinates.length];
        int i = 0;
        while (i < this.coordinates.length) {
            copyCurve.coordinates[i] = new PVector(this.coordinates[i].x, this.coordinates[i].y);
            ++i;
        }
        copyCurve.controlZero = new PVector(this.controlZero.x, this.controlZero.y);
        copyCurve.controlLast = new PVector(this.controlLast.x, this.controlLast.y);
        return copyCurve;
    }

    public Float getArcLength() {
        if (this.arcLength == null) {
            this.computeArcLength();
        }
        return this.arcLength;
    }

    public Curve setControlPoint(int which, PVector p) {
        if (which < 0) {
            this.controlZero = p;
        } else {
            this.controlLast = p;
        }
        return this;
    }

    @Override
    public Curve setRotation(float angle) {
        return this.rotate(this.coordinates[0], angle - this.getRotation().floatValue());
    }

    @Override
    public Curve setRotation(PVector rotationCenter, float angle) {
        return this.rotate(rotationCenter, angle - this.getRotation().floatValue());
    }

    @Override
    public Curve setX(float x) {
        return this.translate(x - this.getX().floatValue(), 0.0f);
    }

    @Override
    public Curve setY(float y) {
        return this.translate(0.0f, y - this.getY().floatValue());
    }

    @Override
    public Curve setLocation(float x, float y) {
        return this.translate(x - this.getX().floatValue(), y - this.getY().floatValue());
    }

    public Curve setLength(float newLength) {
        return this.setLength(this.getStart(), newLength);
    }

    public Curve setLength(PVector center, float newLength) {
        if (newLength > (float)(this.size() * 2) && (double)RMath.abs(this.getLength() - newLength) > 0.5) {
            float scale = newLength / this.getLength();
            return this.scale(center, scale);
        }
        return this;
    }

    public PVector intersection(Line curveSeg, Line other) {
        return this.intersection(curveSeg, other, false);
    }

    public PVector intersection(Line curveSeg, Line other, boolean ignoreStartEnd) {
        Line line1 = curveSeg;
        PVector start1 = line1.getStart();
        PVector dir1 = line1.toRotationVector();
        float l1 = line1.getLength();
        Line line2 = other;
        PVector start2 = line2.getStart();
        PVector dir2 = line2.toRotationVector();
        float l2 = line2.getLength();
        float skalar2 = (start2.y * dir1.x - start1.y * dir1.x - dir1.y * start2.x + start1.x * dir1.y) / (dir2.x * dir1.y - dir2.y * dir1.x);
        float skalar1 = (start2.x + skalar2 * dir2.x - start1.x) / dir1.x;
        if (Float.isInfinite(skalar2) || Float.isInfinite(skalar1)) {
            return null;
        }
        if (Float.isNaN(skalar2) || Float.isNaN(skalar1)) {
            line1.computeMinMax();
            line2.computeMinMax();
            Rect r1 = line1.getBoundingBox();
            Rect r2 = line2.getBoundingBox();
            float x1 = RMath.max(r1.getStart().x, r2.getStart().x);
            float y1 = RMath.max(r1.getStart().y, r2.getStart().y);
            return new PVector(x1, y1);
        }
        if (skalar1 < 0.0f || skalar2 < 0.0f) {
            return null;
        }
        PVector crossed = dir1;
        crossed.mult(skalar1);
        crossed.add(start1);
        if (ignoreStartEnd && ((double)crossed.dist(start2) < (double)l2 * 0.25 || (double)crossed.dist(line2.getEnd()) < (double)l2 * 0.25)) {
            return null;
        }
        if (crossed.dist(start1) > l1 || crossed.dist(start2) > l2) {
            return null;
        }
        return crossed;
    }

    public boolean hasIntersection(Line curveSeg, Line other) {
        return this.hasIntersection(curveSeg, other, false);
    }

    public boolean hasIntersection(Line curveSeg, Line other, boolean ignoreStartEnd) {
        PVector sec = this.intersection(curveSeg, other, ignoreStartEnd);
        return sec != null;
    }

    public void removeIntersectingLines(ArrayList<Line> toRemove) {
        this.removeIntersectingLines(toRemove, false);
    }

    public void removeIntersectingLines(ArrayList<Line> toRemove, boolean ignoreStartEnd) {
        int i = 0;
        while (i < this.size() - 1) {
            Line line = new Line(this.parent, this.get(i), this.get(i + 1));
            int j = 0;
            while (j < toRemove.size()) {
                if (this.hasIntersection(line, toRemove.get(j), ignoreStartEnd)) {
                    toRemove.remove(j);
                    --j;
                }
                ++j;
            }
            ++i;
        }
    }

    private float[][] coordsByI(Integer i) {
        if (i == this.coordinates.length - 1) {
            return null;
        }
        float[][] coords = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}};
        if (i == 0) {
            coords[0][0] = this.controlZero.x;
            coords[1][0] = this.controlZero.y;
            coords[0][1] = this.coordinates[i.intValue()].x;
            coords[1][1] = this.coordinates[i.intValue()].y;
            coords[0][2] = this.coordinates[i.intValue() + 1].x;
            coords[1][2] = this.coordinates[i.intValue() + 1].y;
            coords[0][3] = this.coordinates[i.intValue() + 2].x;
            coords[1][3] = this.coordinates[i.intValue() + 2].y;
        } else if (i == this.coordinates.length - 2) {
            coords[0][0] = this.coordinates[i.intValue() - 1].x;
            coords[1][0] = this.coordinates[i.intValue() - 1].y;
            coords[0][1] = this.coordinates[i.intValue()].x;
            coords[1][1] = this.coordinates[i.intValue()].y;
            coords[0][2] = this.coordinates[i.intValue() + 1].x;
            coords[1][2] = this.coordinates[i.intValue() + 1].y;
            coords[0][3] = this.controlLast.x;
            coords[1][3] = this.controlLast.y;
        } else if (i < this.coordinates.length - 1) {
            coords[0][0] = this.coordinates[i.intValue() - 1].x;
            coords[1][0] = this.coordinates[i.intValue() - 1].y;
            coords[0][1] = this.coordinates[i.intValue()].x;
            coords[1][1] = this.coordinates[i.intValue()].y;
            coords[0][2] = this.coordinates[i.intValue() + 1].x;
            coords[1][2] = this.coordinates[i.intValue() + 1].y;
            coords[0][3] = this.coordinates[i.intValue() + 2].x;
            coords[1][3] = this.coordinates[i.intValue() + 2].y;
        }
        return coords;
    }

    public float[] getNormal(float tplusi) {
        tplusi = RMath.constrain(tplusi, 0.0f, (float)(this.coordinates.length - 1));
        int i = (int)tplusi;
        float t = tplusi - (float)i;
        float[][] coords = this.coordsByI(i);
        if (coords == null) {
            PVector normalVec = Line.getNormal(this.getEnd(), this.controlLast);
            return new float[]{this.getEnd().x, this.getEnd().y, normalVec.heading()};
        }
        PVector point = this.curvePoint(coords, t);
        float tangent = this.curveTangent(coords, t);
        return new float[]{point.x, point.y, -1.5707964f + tangent};
    }

    private float curveTangent(float[][] vals, float t) {
        float tt3 = t * t * 3.0f;
        float t2 = t * 2.0f;
        float[][] cb = curveBaseMatrix;
        float[] sums = new float[]{tt3 * cb[0][0] + t2 * cb[1][0] + cb[2][0], tt3 * cb[0][1] + t2 * cb[1][1] + cb[2][1], tt3 * cb[0][2] + t2 * cb[1][2] + cb[2][2], tt3 * cb[0][3] + t2 * cb[1][3] + cb[2][3]};
        float tx = 0.0f;
        float ty = 0.0f;
        int i = 0;
        while (i < sums.length) {
            tx += vals[0][i] * sums[i];
            ty += vals[1][i] * sums[i];
            ++i;
        }
        return PApplet.atan2((float)ty, (float)tx);
    }

    public float curveTangent(float tplusi) {
        tplusi = RMath.constrain(tplusi, 0.0f, (float)(this.coordinates.length - 1));
        int i = (int)tplusi;
        float t = tplusi - (float)i;
        float[][] coords = this.coordsByI(i);
        if (coords == null) {
            Line line = new Line(this.parent, this.getEnd(), this.controlLast);
            return line.getRotation().floatValue();
        }
        return this.curveTangent(coords, t);
    }

    public PVector curvePoint(float tplusi) {
        tplusi = RMath.constrain(tplusi, 0.0f, (float)(this.coordinates.length - 1));
        int i = (int)tplusi;
        float t = tplusi - (float)i;
        float[][] coords = this.coordsByI(i);
        if (coords == null) {
            return this.getEnd().copy();
        }
        return this.curvePoint(coords, t);
    }

    private PVector curvePoint(float[][] vals, float t) {
        float tt = t * t;
        float ttt = t * tt;
        float[][] cb = curveBaseMatrix;
        float[] sums = new float[]{ttt * cb[0][0] + tt * cb[1][0] + t * cb[2][0] + cb[3][0], ttt * cb[0][1] + tt * cb[1][1] + t * cb[2][1] + cb[3][1], ttt * cb[0][2] + tt * cb[1][2] + t * cb[2][2] + cb[3][2], ttt * cb[0][3] + tt * cb[1][3] + t * cb[2][3] + cb[3][3]};
        float x = 0.0f;
        float y = 0.0f;
        int i = 0;
        while (i < sums.length) {
            x += vals[0][i] * sums[i];
            y += vals[1][i] * sums[i];
            ++i;
        }
        return new PVector(x, y);
    }

    private void computeArcLength() {
        this.ranges.clear();
        float summedLength = 0.0f;
        ArrayList<PVector> controlPoints = new ArrayList<PVector>();
        int steps = 30;
        int i = 0;
        while (i < this.size() - 1) {
            controlPoints.clear();
            int j = 0;
            while (j < steps) {
                float t = (float)i + (float)j / (float)steps;
                controlPoints.add(this.curvePoint(t));
                ++j;
            }
            LineSegments seg = new LineSegments(this.parent, controlPoints);
            float segmentLength = seg.getArcLength();
            this.ranges.add(new SegmentRange(i, (summedLength += segmentLength) - segmentLength, summedLength));
            ++i;
        }
        this.arcLength = Float.valueOf(summedLength);
    }

    public float arcLengthToTPlusI(float arclength) {
        if (this.arcLength == null) {
            this.computeArcLength();
        }
        float t = 0.0f;
        int index = 0;
        boolean found = false;
        int i = 0;
        while (i < this.ranges.size()) {
            if (arclength >= this.ranges.get(i).beginRange && arclength <= this.ranges.get(i).endRange) {
                t = this.ranges.get(i).getT(arclength);
                index = this.ranges.get(i).index;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            index = this.coordinates.length - 1;
            t = 1.0f;
        }
        return (float)index + t;
    }

    public void computeMinMax() {
        float[] vals = RMath.range(this.coordinates);
        this.minX = Float.valueOf(vals[0]);
        this.maxX = Float.valueOf(vals[2]);
        this.minY = Float.valueOf(vals[1]);
        this.maxY = Float.valueOf(vals[3]);
    }

    private void computeControlZero() {
        float a = PApplet.atan2((float)(this.getStart().y - this.coordinates[1].y), (float)(this.getStart().x - this.coordinates[1].x));
        float s = this.getStart().dist(this.coordinates[1]);
        this.controlZero = RMath.polarToCartesian(this.getStart(), a, s);
    }

    private void computeControlLast() {
        float a = PApplet.atan2((float)(this.getEnd().y - this.coordinates[this.coordinates.length - 2].y), (float)(this.getEnd().x - this.coordinates[this.coordinates.length - 2].x));
        float s = this.coordinates[this.coordinates.length - 2].dist(this.getEnd());
        this.controlLast = RMath.polarToCartesian(this.getEnd(), a, s);
    }

    @Override
    public Curve translate(float x, float y) {
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            p.x += x;
            p.y += y;
            ++i;
        }
        this.controlLast.x += x;
        this.controlLast.y += y;
        this.controlZero.x += x;
        this.controlZero.y += y;
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Curve rotate(float angle) {
        return this.rotate(this.coordinates[0], angle);
    }

    @Override
    public Curve rotate(PVector rotationCenter, float angle) {
        PVector center = rotationCenter;
        float a = 0.0f;
        float d = 0.0f;
        int i = 0;
        while (i < this.coordinates.length) {
            PVector p = this.coordinates[i];
            a = angle + PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
            d = center.dist(p);
            p.x = center.x + PApplet.cos((float)a) * d;
            p.y = center.y + PApplet.sin((float)a) * d;
            ++i;
        }
        a = angle + PApplet.atan2((float)(this.controlLast.y - center.y), (float)(this.controlLast.x - center.x));
        d = center.dist(this.controlLast);
        this.controlLast.x = center.x + PApplet.cos((float)a) * d;
        this.controlLast.y = center.y + PApplet.sin((float)a) * d;
        a = angle + PApplet.atan2((float)(this.controlZero.y - center.y), (float)(this.controlZero.x - center.x));
        d = center.dist(this.controlZero);
        this.controlZero.x = center.x + PApplet.cos((float)a) * d;
        this.controlZero.y = center.y + PApplet.sin((float)a) * d;
        this.minX = null;
        this.boundingBox = null;
        return this;
    }

    @Override
    public Curve scale(float scale) {
        return this.scale(this.coordinates[0], scale, scale);
    }

    @Override
    public Curve scale(PVector scaleCenter, float scale) {
        return this.scale(scaleCenter, scale, scale);
    }

    public Curve scale(PVector scaleCenter, float scaleX, float scaleY) {
        if ((double)RMath.abs(scaleX) > 0.01 && (double)RMath.abs(scaleY) > 0.01) {
            PVector center = scaleCenter;
            float rotation = this.getRotation().floatValue();
            if (rotation != 0.0f) {
                this.setRotation(0.0f);
            }
            float dx = 0.0f;
            float dy = 0.0f;
            float a = 0.0f;
            int i = 0;
            while (i < this.coordinates.length) {
                PVector p = this.coordinates[i];
                a = PApplet.atan2((float)(p.y - center.y), (float)(p.x - center.x));
                float dis = center.dist(p);
                dx = dis * scaleX;
                dy = dis * scaleY;
                p.x = center.x + PApplet.cos((float)a) * dx;
                p.y = center.y + PApplet.sin((float)a) * dy;
                ++i;
            }
            this.minX = null;
            this.boundingBox = null;
            if (rotation != 0.0f) {
                this.setRotation(rotation);
            }
            this.computeControlZero();
            this.computeControlLast();
        }
        return this;
    }

    @Override
    public Curve draw() {
        this.parent.beginShape();
        this.parent.curveVertex(this.controlZero.x, this.controlZero.y);
        int i = 0;
        while (i < this.coordinates.length) {
            this.parent.curveVertex(this.coordinates[i].x, this.coordinates[i].y);
            ++i;
        }
        this.parent.curveVertex(this.controlLast.x, this.controlLast.y);
        this.parent.endShape();
        return this;
    }

    public Curve toSmoothedCurve() {
        return this.toLineSegments(this.size()).getCurve();
    }

    public Curve toSmoothedCurve(int details) {
        return this.toLineSegments(details).getCurve();
    }

    public Curve toSmoothedCurve(float detailScale) {
        return this.toLineSegments(detailScale).getCurve();
    }

    public LineSegments getLineSegments() {
        return new LineSegments(this.parent, this.coordinates);
    }

    public LineSegments toLineSegments() {
        return new LineSegments(this.parent, this.copy().coordinates);
    }

    public LineSegments toLineSegments(float detailScale) {
        return this.toLineSegments((int)((float)this.size() * detailScale));
    }

    public LineSegments toLineSegments(int details) {
        ArrayList<PVector> controlPoints = new ArrayList<PVector>();
        if (details < 3) {
            details = 3;
        }
        int i = 0;
        while (i < details) {
            float arcLength = PApplet.map((float)i, (float)0.0f, (float)(details - 1), (float)0.0f, (float)this.getArcLength().floatValue());
            float t = this.arcLengthToTPlusI(arcLength);
            controlPoints.add(this.curvePoint(t));
            ++i;
        }
        if ((double)this.getEnd().dist((PVector)controlPoints.get(controlPoints.size() - 1)) > 0.1) {
            controlPoints.add(this.getEnd().copy());
        }
        return new LineSegments(this.parent, controlPoints);
    }

    private class SegmentRange {
        private int index;
        private float beginRange;
        private float endRange;

        private SegmentRange(int index, float beginRange, float endRange) {
            this.index = index;
            this.beginRange = beginRange;
            this.endRange = endRange;
        }

        private float getT(float val) {
            return PApplet.map((float)val, (float)this.beginRange, (float)this.endRange, (float)0.0f, (float)1.0f);
        }

        private float getArcLength() {
            return this.endRange - this.beginRange;
        }
    }
}

