/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.grid;

import net.returnvoid.graphics.grid.RGrid;
import net.returnvoid.tools.RMath;
import processing.core.PVector;

public class TableGrid
implements RGrid {
    private Float x;
    private Float y;
    private Float w;
    private Float h;
    private Float paddingX;
    private Float paddingY;
    private Integer columns;
    private Integer rows;
    private boolean wasUpdated;
    private PVector[] coordinates;

    public TableGrid(float x, float y, float w, float h, int columns, int rows, float paddingX, float paddingY) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.w = Float.valueOf(w < 0.0f ? w * -1.0f : (w < (float)columns ? (float)columns : w));
        this.h = Float.valueOf(h < 0.0f ? h * -1.0f : (h < (float)rows ? (float)rows : h));
        this.columns = columns;
        this.rows = rows;
        this.paddingX = Float.valueOf(paddingX);
        this.paddingY = Float.valueOf(paddingY);
        this.wasUpdated = true;
    }

    @Override
    public TableGrid setX(float x) {
        this.wasUpdated = true;
        this.x = Float.valueOf(x);
        return this;
    }

    @Override
    public TableGrid setY(float y) {
        this.wasUpdated = true;
        this.y = Float.valueOf(y);
        return this;
    }

    public TableGrid setWidth(float w) {
        this.w = Float.valueOf(w < (float)this.columns.intValue() ? (float)this.columns.intValue() : w);
        return this;
    }

    public TableGrid setHeight(float h) {
        this.h = Float.valueOf(h < (float)this.rows.intValue() ? (float)this.rows.intValue() : h);
        return this;
    }

    public TableGrid setDimension(float s) {
        return this.setWidth(s).setHeight(s);
    }

    public TableGrid setDimension(float w, float h) {
        return this.setWidth(w).setHeight(h);
    }

    public TableGrid setCellWidth(float cellWidth) {
        float maxW = this.w.floatValue() / (float)this.columns.intValue();
        float newW = cellWidth < 1.0f ? 1.0f : (cellWidth > maxW ? maxW : cellWidth);
        float newPaddingX = 1.0f - newW / (this.w.floatValue() / (float)this.columns.intValue());
        return this.setPaddingX(newPaddingX);
    }

    public TableGrid setCellHeight(float cellHeight) {
        float maxH = this.h.floatValue() / (float)this.rows.intValue();
        float newH = cellHeight < 1.0f ? 1.0f : (cellHeight > maxH ? maxH : cellHeight);
        float newPaddingY = 1.0f - newH / (this.h.floatValue() / (float)this.rows.intValue());
        return this.setPaddingY(newPaddingY);
    }

    public TableGrid setPadding() {
        return this.setPaddingX().setPaddingY();
    }

    public TableGrid setPaddingX() {
        return this.setPaddingX(0.5f);
    }

    public TableGrid setPaddingY() {
        return this.setPaddingY(0.5f);
    }

    @Override
    public TableGrid setPadding(float padding) {
        return this.setPaddingX(padding).setPaddingY(padding);
    }

    public TableGrid setPaddingX(float paddingX) {
        this.paddingX = Float.valueOf(paddingX);
        return this;
    }

    public TableGrid setPaddingY(float paddingY) {
        this.paddingY = Float.valueOf(paddingY);
        return this;
    }

    public TableGrid setSize(Integer size) {
        size = RMath.abs(size);
        float aspectRatio = this.w.floatValue() / this.h.floatValue();
        int numX = (int)Math.pow((float)size.intValue() * aspectRatio, 0.5);
        int numY = (int)((float)size.intValue() / (float)numX);
        if (numX < 1) {
            numX = 1;
        }
        if (numY < 1) {
            numY = 1;
        }
        this.rows = numY;
        this.columns = numX;
        this.wasUpdated = true;
        return this;
    }

    public TableGrid setColumns(Integer columns) {
        if ((columns = Integer.valueOf(RMath.abs(columns))) < 1) {
            columns = 1;
        }
        this.columns = columns;
        this.wasUpdated = true;
        return this;
    }

    public TableGrid setRows(Integer rows) {
        if ((rows = Integer.valueOf(RMath.abs(rows))) < 1) {
            rows = 1;
        }
        this.rows = rows;
        this.wasUpdated = true;
        return this;
    }

    private void initCoordinates() {
        this.coordinates = new PVector[this.size().intValue()];
        int i = 0;
        while (i < this.coordinates.length) {
            this.coordinates[i] = new PVector(this.getX(i).floatValue(), this.getY(i).floatValue());
            ++i;
        }
    }

    @Override
    public PVector[] getCoordinates() {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        return this.coordinates;
    }

    public Integer columns() {
        return this.columns;
    }

    public Integer rows() {
        return this.rows;
    }

    @Override
    public Integer size() {
        return this.columns * this.rows;
    }

    public Float getPaddingX() {
        return this.paddingX;
    }

    public Float getPaddingY() {
        return this.paddingY;
    }

    @Override
    public Float getPadding() {
        return Float.valueOf(0.5f * (this.getPaddingX().floatValue() + this.getPaddingY().floatValue()));
    }

    @Override
    public Float getWidth() {
        return this.w;
    }

    @Override
    public Float getHeight() {
        return this.h;
    }

    @Override
    public Float getX() {
        return this.x;
    }

    @Override
    public Float getY() {
        return this.y;
    }

    public Float getRowX(Integer rowIndex) {
        return this.getX(this.index(rowIndex, 0));
    }

    public Float getRowY(Integer rowIndex) {
        return this.getY(this.index(rowIndex, 0));
    }

    public Float getColumnX(Integer columnIndex) {
        return this.getX(this.index(0, columnIndex));
    }

    public Float getColumnY(Integer columnIndex) {
        return this.getY(this.index(0, columnIndex));
    }

    @Override
    public Float getX(Integer index) {
        int j = index % this.columns;
        return Float.valueOf(this.x.floatValue() + ((float)j + 0.5f) * this.w.floatValue() / (float)this.columns.intValue());
    }

    @Override
    public Float getY(Integer index) {
        int i = (index - index % this.columns) / this.columns;
        return Float.valueOf(this.y.floatValue() + ((float)i + 0.5f) * this.h.floatValue() / (float)this.rows.intValue());
    }

    public Integer getRow(Integer index) {
        return (index - index % this.columns) / this.columns;
    }

    public Integer getColumn(int index) {
        return index % this.columns;
    }

    public boolean isEvenRow(int index) {
        return this.getRow(index) % 2 == 0;
    }

    public boolean isEvenColumn(int index) {
        return this.getColumn(index) % 2 == 0;
    }

    public Integer index(Integer row, Integer column) {
        return row * this.columns + column;
    }

    public Float cellWidth() {
        return Float.valueOf((1.0f - this.paddingX.floatValue()) * this.w.floatValue() / (float)this.columns.intValue());
    }

    public Float cellHeight() {
        return Float.valueOf((1.0f - this.paddingY.floatValue()) * this.h.floatValue() / (float)this.rows.intValue());
    }

    @Override
    public Float getWidth(Integer i) {
        return this.cellWidth();
    }

    @Override
    public Float getHeight(Integer i) {
        return this.cellHeight();
    }
}

