/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.grid;

import net.returnvoid.graphics.grid.RGrid;
import net.returnvoid.tools.RMath;
import processing.core.PVector;

public class SpiralGrid
implements RGrid {
    private Float x;
    private Float y;
    private Float endRadius;
    private Float startRadius;
    private Float angleSteps;
    private Float startAngle;
    private Integer dir;
    private Float rotations;
    private boolean wasUpdated;
    private Float padding;
    private PVector[] coordinates;

    public SpiralGrid(float x, float y, float angleSteps, float startAngle, float rotations, Integer dir, float startRadius, float endRadius) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.padding = Float.valueOf(0.0f);
        this.endRadius = Float.valueOf(endRadius);
        this.startRadius = Float.valueOf(startRadius);
        this.startAngle = Float.valueOf(startAngle);
        this.wasUpdated = true;
        this.setRotations(rotations);
        this.setAngleSteps(angleSteps);
        this.setRotationDirection(dir);
    }

    public SpiralGrid setRotations(float r) {
        this.rotations = Float.valueOf((r = RMath.abs(r)) > 0.0f ? r : 0.1f);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setStartAngle(float radians) {
        this.startAngle = Float.valueOf(radians);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setStartAngleDeg(float degrees) {
        return this.setStartAngle((float)Math.PI * 2 * degrees / 360.0f);
    }

    public SpiralGrid setRotationDirection(Integer dir) {
        this.dir = dir < 0 ? -1 : 1;
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setAngleSteps(float radians) {
        this.angleSteps = Float.valueOf(RMath.abs(radians) < 0.001f ? 0.001f : radians);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setAngleStepsDeg(float degrees) {
        return this.setAngleSteps((float)Math.PI * 2 * degrees / 360.0f);
    }

    @Override
    public SpiralGrid setX(float x) {
        this.x = Float.valueOf(x);
        this.wasUpdated = true;
        return this;
    }

    @Override
    public SpiralGrid setY(float y) {
        this.y = Float.valueOf(y);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setEndRadius(float r) {
        this.endRadius = Float.valueOf(r);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setStartRadius(float r) {
        this.startRadius = Float.valueOf(r);
        this.wasUpdated = true;
        return this;
    }

    public SpiralGrid setSize(Integer size) {
        if ((size = Integer.valueOf(RMath.abs(size))) < 1) {
            size = 1;
        }
        return this.setAngleSteps(this.rotations.floatValue() * ((float)Math.PI * 2) / (float)(size - 1));
    }

    @Override
    public SpiralGrid setPadding(float padding) {
        this.padding = Float.valueOf(padding);
        return this;
    }

    private void initCoordinates() {
        this.coordinates = new PVector[this.size().intValue()];
        int i = 0;
        while (i < this.coordinates.length) {
            this.coordinates[i] = new PVector(this.getX(i).floatValue(), this.getY(i).floatValue());
            ++i;
        }
    }

    @Override
    public PVector[] getCoordinates() {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        return this.coordinates;
    }

    @Override
    public Integer size() {
        return (int)(this.rotations.floatValue() * ((float)Math.PI * 2) / this.angleSteps.floatValue()) + 1;
    }

    public Float getRotations() {
        return this.rotations;
    }

    public Float getStartAngle() {
        return this.startAngle;
    }

    public Integer getRotationDirection() {
        return this.dir;
    }

    public Float getAngleSteps() {
        return this.angleSteps;
    }

    @Override
    public Float getX() {
        return this.x;
    }

    @Override
    public Float getY() {
        return this.y;
    }

    @Override
    public Float getWidth() {
        return Float.valueOf(this.endRadius.floatValue() > this.startRadius.floatValue() ? this.endRadius.floatValue() * 2.0f : this.startRadius.floatValue() * 2.0f);
    }

    @Override
    public Float getHeight() {
        return Float.valueOf(this.endRadius.floatValue() > this.startRadius.floatValue() ? this.endRadius.floatValue() * 2.0f : this.startRadius.floatValue() * 2.0f);
    }

    public Float getEndRadius() {
        return this.endRadius;
    }

    public Float getStartRadius() {
        return this.startRadius;
    }

    public Float getAngle(Integer index) {
        return Float.valueOf(this.startAngle.floatValue() + (float)index.intValue() * this.angleSteps.floatValue() + (this.dir == 1 ? 0.0f : -1.5707964f));
    }

    public Float getRadius(Integer index) {
        return Float.valueOf(this.startRadius.floatValue() + (float)index.intValue() * (this.endRadius.floatValue() - this.startRadius.floatValue()) / (float)this.size().intValue());
    }

    @Override
    public Float getX(Integer index) {
        Float angle = this.getAngle(index);
        Float radius = this.getRadius(index);
        return Float.valueOf((float)((double)this.x.floatValue() + (double)this.dir.intValue() * Math.cos(angle.floatValue()) * (double)radius.floatValue()));
    }

    @Override
    public Float getY(Integer index) {
        Float angle = this.getAngle(index);
        Float radius = this.getRadius(index);
        return Float.valueOf((float)((double)this.y.floatValue() + (double)this.dir.intValue() * Math.sin(angle.floatValue()) * (double)radius.floatValue()));
    }

    @Override
    public Float getPadding() {
        return this.padding;
    }

    public Float elementSize(Integer index) {
        Float prevY;
        Float nextY;
        Float prevX;
        Float nextX;
        Float x = this.getX(index);
        Float y = this.getY(index);
        if (index == 0) {
            prevX = nextX = this.getX(index + 1);
            prevY = nextY = this.getY(index + 1);
        } else {
            prevX = this.getX(index - 1);
            prevY = this.getY(index - 1);
            nextX = this.getX(index + 1);
            nextY = this.getY(index + 1);
        }
        return Float.valueOf(0.5f * (float)(Math.pow(Math.pow(prevX.floatValue() - x.floatValue(), 2.0) + Math.pow(prevY.floatValue() - y.floatValue(), 2.0), 0.5) + Math.pow(Math.pow(nextX.floatValue() - x.floatValue(), 2.0) + Math.pow(nextY.floatValue() - y.floatValue(), 2.0), 0.5)) * (1.0f - this.padding.floatValue()));
    }

    @Override
    public Float getWidth(Integer i) {
        return this.elementSize(i);
    }

    @Override
    public Float getHeight(Integer i) {
        return this.elementSize(i);
    }
}

