/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.grid;

import net.returnvoid.graphics.grid.EllipseGrid;
import net.returnvoid.graphics.grid.EquiSpiralGrid;
import net.returnvoid.graphics.grid.SpiralGrid;
import net.returnvoid.graphics.grid.TableGrid;

public class GridMaker {
    private GridMaker() {
    }

    public static SpiralGrid createSpiral() {
        return GridMaker.createSpiral(0.0f, 0.0f, 0.31415927f);
    }

    public static SpiralGrid createSpiral(float x, float y) {
        return GridMaker.createSpiral(x, y, 0.31415927f);
    }

    public static SpiralGrid createSpiral(float x, float y, float angle) {
        Float maxRadius = Float.valueOf(100.0f);
        Float minRadius = Float.valueOf(0.0f);
        Float startAngle = Float.valueOf(0.0f);
        Float rotations = Float.valueOf(1.0f);
        Integer dir = 1;
        SpiralGrid grid = new SpiralGrid(x, y, angle, startAngle.floatValue(), rotations.floatValue(), dir, minRadius.floatValue(), maxRadius.floatValue());
        return grid;
    }

    public static SpiralGrid createSpiral(float x, float y, float angle, float rotations) {
        Float maxRadius = Float.valueOf(100.0f);
        Float minRadius = Float.valueOf(0.0f);
        Float startAngle = Float.valueOf(0.0f);
        Integer dir = 1;
        SpiralGrid grid = new SpiralGrid(x, y, angle, startAngle.floatValue(), rotations, dir, minRadius.floatValue(), maxRadius.floatValue());
        return grid;
    }

    public static SpiralGrid createSpiral(float x, float y, float radius, float angle, float rotations) {
        Float minRadius = Float.valueOf(0.0f);
        Float startAngle = Float.valueOf(0.0f);
        Integer dir = 1;
        SpiralGrid grid = new SpiralGrid(x, y, angle, startAngle.floatValue(), rotations, dir, minRadius.floatValue(), radius);
        return grid;
    }

    public static SpiralGrid createSpiral(float x, float y, int size, float rotations, float endRadius) {
        float minRadius = 0.0f;
        float startAngle = 0.0f;
        float angleSteps = 0.31415927f;
        Integer dir = 1;
        SpiralGrid grid = new SpiralGrid(x, y, angleSteps, startAngle, rotations, dir, minRadius, endRadius);
        return grid.setSize(size);
    }

    public static EllipseGrid createEllipse() {
        EllipseGrid grid = new EllipseGrid(0.0f, 0.0f, 100.0f, 100.0f, 20, 0.0f);
        return grid;
    }

    public static EllipseGrid createEllipse(float x, float y) {
        EllipseGrid grid = new EllipseGrid(x, y, 100.0f, 100.0f, 20, 0.0f);
        return grid;
    }

    public static EllipseGrid createEllipse(float x, float y, float radius) {
        EllipseGrid grid = new EllipseGrid(x, y, radius, radius, 20, 0.0f);
        return grid;
    }

    public static EllipseGrid createEllipse(float x, float y, float radius, int size) {
        EllipseGrid grid = new EllipseGrid(x, y, radius, radius, size, 0.0f);
        return grid;
    }

    public static TableGrid createTable() {
        TableGrid grid = new TableGrid(0.0f, 0.0f, 100.0f, 100.0f, 10, 10, 0.0f, 0.0f);
        return grid;
    }

    public static TableGrid createTable(float w, float h, int size) {
        boolean wh = w > h;
        float aspectRatio = wh ? w / h : h / w;
        int numX = 0;
        int numY = 0;
        if (w == h) {
            numX = numY = (int)Math.pow((float)size * aspectRatio, 0.5);
        } else if (wh) {
            numX = (int)Math.pow((float)size * aspectRatio, 0.5);
            numY = (int)((float)size / (float)numX);
        } else {
            numY = (int)Math.pow((float)size * aspectRatio, 0.5);
            numX = (int)((float)size / (float)numY);
        }
        if (numX < 1) {
            numX = 1;
        }
        if (numY < 1) {
            numY = 1;
        }
        TableGrid grid = new TableGrid(0.0f, 0.0f, w, h, numX, numY, 0.0f, 0.0f);
        return grid;
    }

    public static TableGrid createTable(float w, float h, int columns, int rows) {
        TableGrid grid = new TableGrid(0.0f, 0.0f, w, h, columns, rows, 0.0f, 0.0f);
        return grid;
    }

    public static TableGrid createTable(float x, float y, float w, float h, int size) {
        boolean wh = w > h;
        float aspectRatio = wh ? w / h : h / w;
        int numX = 0;
        int numY = 0;
        if (w == h) {
            numX = numY = (int)Math.pow((float)size * aspectRatio, 0.5);
        } else if (wh) {
            numX = (int)Math.pow((float)size * aspectRatio, 0.5);
            numY = (int)((float)size / (float)numX);
        } else {
            numY = (int)Math.pow((float)size * aspectRatio, 0.5);
            numX = (int)((float)size / (float)numY);
        }
        if (numX < 1) {
            numX = 1;
        }
        if (numY < 1) {
            numY = 1;
        }
        TableGrid grid = new TableGrid(x, y, w, h, numX, numY, 0.0f, 0.0f);
        return grid;
    }

    public static TableGrid createTable(float x, float y, float w, float h, int columns, int rows) {
        TableGrid grid = new TableGrid(x, y, w, h, columns, rows, 0.0f, 0.0f);
        return grid;
    }

    public static EquiSpiralGrid createEquiSpiral() {
        EquiSpiralGrid grid = new EquiSpiralGrid(0.0f, 0.0f, 0.0f, 100.0f, 30.0f, 1.0f, 0.0f, 1);
        return grid;
    }

    public static EquiSpiralGrid createEquiSpiral(float x, float y) {
        EquiSpiralGrid grid = new EquiSpiralGrid(x, y, 0.0f, 100.0f, 30.0f, 1.0f, 0.0f, 1);
        return grid;
    }

    public static EquiSpiralGrid createEquiSpiral(float x, float y, float radius) {
        EquiSpiralGrid grid = new EquiSpiralGrid(x, y, 0.0f, radius, 30.0f, 1.0f, 0.0f, 1);
        return grid;
    }

    public static EquiSpiralGrid createEquiSpiral(float x, float y, float radius, float elementDistance) {
        EquiSpiralGrid grid = new EquiSpiralGrid(x, y, 0.0f, radius, elementDistance, 1.0f, 0.0f, 1);
        return grid;
    }

    public static EquiSpiralGrid createEquiSpiral(float x, float y, float radius, float elementDistance, float rotations) {
        EquiSpiralGrid grid = new EquiSpiralGrid(x, y, 0.0f, radius, elementDistance, rotations, 0.0f, 1);
        return grid;
    }
}

