/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.grid;

import java.util.ArrayList;
import net.returnvoid.graphics.grid.RGrid;
import net.returnvoid.tools.RMath;
import processing.core.PVector;

public class EquiSpiralGrid
implements RGrid {
    private Float x;
    private Float y;
    private Float endRadius;
    private Float startRadius;
    private Float elementDistance;
    private Float startAngle;
    private Integer dir;
    private Float rotations;
    private boolean wasUpdated;
    private Float padding;
    private ArrayList<PVector> coordinates;

    public EquiSpiralGrid(float x, float y, float startRadius, float endRadius, float elementDistance, float rotations, float startAngle, int dir) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.padding = Float.valueOf(0.0f);
        this.setStartRadius(startRadius);
        this.setEndRadius(endRadius);
        this.elementDistance = Float.valueOf(elementDistance);
        if (this.elementDistance.floatValue() < 1.0f) {
            this.elementDistance = Float.valueOf(1.0f);
        }
        this.setStartAngle(startAngle);
        this.setRotationDirection(dir);
        this.setRotations(rotations);
        this.wasUpdated = true;
    }

    @Override
    public EquiSpiralGrid setX(float x) {
        this.x = Float.valueOf(x);
        this.wasUpdated = true;
        return this;
    }

    @Override
    public EquiSpiralGrid setY(float y) {
        this.y = Float.valueOf(y);
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setStartRadius(float r) {
        this.startRadius = Float.valueOf(Math.abs(r));
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setEndRadius(float r) {
        this.endRadius = Float.valueOf(Math.abs(r));
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setElementDistance(float elementDistance) {
        this.elementDistance = Float.valueOf((elementDistance = Math.abs(elementDistance)) < 1.0f ? 1.0f : elementDistance);
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setStartAngle(float a) {
        a = RMath.abs(a);
        this.startAngle = Float.valueOf(a);
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setRotations(float r) {
        this.rotations = Float.valueOf((r = RMath.abs(r)) < 0.01f ? 0.01f : r);
        this.wasUpdated = true;
        return this;
    }

    public EquiSpiralGrid setRotationDirection(int dir) {
        this.dir = dir < 0 ? -1 : 1;
        this.wasUpdated = true;
        return this;
    }

    @Override
    public EquiSpiralGrid setPadding(float padding) {
        this.padding = Float.valueOf(padding);
        return this;
    }

    private void initCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList();
        }
        this.coordinates.clear();
        float startAngle = (float)this.dir.intValue() * this.startAngle.floatValue() + (this.dir == 1 ? 0.0f : -1.5707964f);
        float radius = 0.0f;
        float maxAngel = (float)((double)this.rotations.floatValue() * Math.PI * 2.0);
        float radiusSteps = (this.endRadius.floatValue() - this.startRadius.floatValue()) / maxAngel;
        float angle = startAngle;
        float xx = (float)((double)this.x.floatValue() + (double)this.dir.intValue() * Math.cos((float)this.dir.intValue() * angle) * (double)(this.startRadius.floatValue() + radius));
        float yy = (float)((double)this.y.floatValue() + Math.sin((float)this.dir.intValue() * angle) * (double)(this.startRadius.floatValue() + radius));
        this.coordinates.add(new PVector(xx, yy));
        angle += this.elementDistance.floatValue() / (this.startRadius.floatValue() + radius < this.elementDistance.floatValue() ? this.elementDistance.floatValue() : this.startRadius.floatValue() + radius);
        while (angle <= maxAngel + startAngle) {
            radius = radiusSteps * (angle - startAngle);
            xx = (float)((double)this.x.floatValue() + (double)this.dir.intValue() * Math.cos((float)this.dir.intValue() * angle) * (double)(this.startRadius.floatValue() + radius));
            yy = (float)((double)this.y.floatValue() + Math.sin((float)this.dir.intValue() * angle) * (double)(this.startRadius.floatValue() + radius));
            this.coordinates.add(new PVector(xx, yy));
            angle += this.elementDistance.floatValue() / (this.startRadius.floatValue() + radius);
        }
    }

    @Override
    public PVector[] getCoordinates() {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        return this.coordinates.toArray(new PVector[this.coordinates.size()]);
    }

    @Override
    public Float getX() {
        return this.x;
    }

    @Override
    public Float getY() {
        return this.y;
    }

    @Override
    public Float getWidth() {
        return Float.valueOf(this.endRadius.floatValue() > this.startRadius.floatValue() ? this.endRadius.floatValue() * 2.0f : this.startRadius.floatValue() * 2.0f);
    }

    @Override
    public Float getHeight() {
        return Float.valueOf(this.endRadius.floatValue() > this.startRadius.floatValue() ? this.endRadius.floatValue() * 2.0f : this.startRadius.floatValue() * 2.0f);
    }

    public Float getStartRadius() {
        return this.startRadius;
    }

    public Float getEndRadius() {
        return this.endRadius;
    }

    public Float getElementDistance() {
        return this.elementDistance;
    }

    public Float getStartAngle() {
        return this.startAngle;
    }

    public Integer getRotationDirection() {
        return this.dir;
    }

    public Float getRotations() {
        return this.rotations;
    }

    @Override
    public Float getPadding() {
        return this.padding;
    }

    @Override
    public Integer size() {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        return this.coordinates.size();
    }

    public Float getAngle(Integer index) {
        Float x = this.getX(index);
        Float y = this.getY(index);
        Float centerX = this.x;
        Float centerY = this.y;
        return Float.valueOf((float)Math.atan2(y.floatValue() - centerY.floatValue(), x.floatValue() - centerX.floatValue()));
    }

    @Override
    public Float getX(Integer index) {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        index = RMath.constrain(index, 0, this.coordinates.size() - 1);
        return Float.valueOf(this.coordinates.get((int)index.intValue()).x);
    }

    @Override
    public Float getY(Integer index) {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        index = RMath.constrain(index, 0, this.coordinates.size() - 1);
        return Float.valueOf(this.coordinates.get((int)index.intValue()).y);
    }

    public PVector get(int index) {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        index = RMath.constrain(index, 0, this.coordinates.size() - 1);
        return this.coordinates.get(index);
    }

    @Override
    public Float getWidth(Integer i) {
        return Float.valueOf(this.getElementDistance().floatValue() * (1.0f - this.padding.floatValue()));
    }

    @Override
    public Float getHeight(Integer i) {
        return Float.valueOf(this.getElementDistance().floatValue() * (1.0f - this.padding.floatValue()));
    }
}

