/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.graphics.grid;

import net.returnvoid.graphics.grid.RGrid;
import net.returnvoid.tools.RMath;
import processing.core.PVector;

public class EllipseGrid
implements RGrid {
    private Float x;
    private Float y;
    private Float radiusX;
    private Float radiusY;
    private Float startAngle;
    private Integer size;
    private boolean wasUpdated;
    private PVector[] coordinates;
    private Float padding;

    EllipseGrid(float x, float y, float radiusX, float radiusY, Integer size, float startAngle) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.radiusX = Float.valueOf(radiusX);
        this.radiusY = Float.valueOf(radiusY);
        this.startAngle = Float.valueOf(startAngle);
        this.padding = Float.valueOf(0.0f);
        this.size = RMath.abs(size);
        this.wasUpdated = true;
        if (this.size < 1) {
            size = 1;
        }
    }

    @Override
    public EllipseGrid setX(float x) {
        this.x = Float.valueOf(x);
        this.wasUpdated = true;
        return this;
    }

    @Override
    public EllipseGrid setY(float y) {
        this.y = Float.valueOf(y);
        this.wasUpdated = true;
        this.wasUpdated = true;
        return this;
    }

    public EllipseGrid setRadius(float r) {
        if ((r = RMath.abs(r)) > 1.0f) {
            this.radiusX = Float.valueOf(r);
            this.radiusY = Float.valueOf(r);
            this.wasUpdated = true;
        }
        return this;
    }

    public EllipseGrid setRadiusX(float r) {
        if ((r = RMath.abs(r)) > 1.0f) {
            this.radiusX = Float.valueOf(r);
            this.wasUpdated = true;
        }
        return this;
    }

    public EllipseGrid setRadiusY(float r) {
        if ((r = RMath.abs(r)) > 1.0f) {
            this.radiusY = Float.valueOf(r);
            this.wasUpdated = true;
        }
        return this;
    }

    public EllipseGrid setSize(Integer size) {
        this.size = (size = Integer.valueOf(RMath.abs(size))) < 1 ? 1 : size;
        this.wasUpdated = true;
        return this;
    }

    public EllipseGrid setStartAngle(float startAngle) {
        this.startAngle = Float.valueOf(startAngle);
        return this;
    }

    @Override
    public EllipseGrid setPadding(float padding) {
        this.padding = Float.valueOf(padding);
        return this;
    }

    private void initCoordinates() {
        this.coordinates = new PVector[this.size().intValue()];
        int i = 0;
        while (i < this.coordinates.length) {
            this.coordinates[i] = new PVector(this.getX(i).floatValue(), this.getY(i).floatValue());
            ++i;
        }
    }

    @Override
    public PVector[] getCoordinates() {
        if (this.wasUpdated) {
            this.initCoordinates();
        }
        return this.coordinates;
    }

    @Override
    public Float getX() {
        return this.x;
    }

    @Override
    public Float getWidth() {
        return Float.valueOf(this.radiusX.floatValue() * 2.0f);
    }

    @Override
    public Float getHeight() {
        return Float.valueOf(this.radiusY.floatValue() * 2.0f);
    }

    @Override
    public Float getY() {
        return this.y;
    }

    public Float getStartAngle() {
        return this.startAngle;
    }

    public Float getRadius() {
        return this.radiusX;
    }

    public Float getRadiusX() {
        return this.radiusX;
    }

    public Float getRadiusY() {
        return this.radiusY;
    }

    @Override
    public Float getPadding() {
        return this.padding;
    }

    @Override
    public Integer size() {
        return this.size;
    }

    public Float getAngle(Integer index) {
        return Float.valueOf(this.startAngle.floatValue() + (float)index.intValue() * ((float)Math.PI * 2) / (float)this.size.intValue());
    }

    @Override
    public Float getX(Integer index) {
        return Float.valueOf((float)((double)this.x.floatValue() + Math.cos(this.getAngle(index).floatValue()) * (double)this.radiusX.floatValue()));
    }

    @Override
    public Float getY(Integer index) {
        return Float.valueOf((float)((double)this.y.floatValue() + Math.sin(this.getAngle(index).floatValue()) * (double)this.radiusY.floatValue()));
    }

    public Float elementSize() {
        Float y2;
        Float x2;
        Float x1 = this.getX(0);
        Float y1 = this.getY(0);
        if (this.size() == 1) {
            x2 = this.getRadiusX();
            y2 = this.getRadiusY();
        } else {
            x2 = this.getX(1);
            y2 = this.getY(1);
        }
        return Float.valueOf((float)Math.pow(Math.pow(x1.floatValue() - x2.floatValue(), 2.0) + Math.pow(y1.floatValue() - y2.floatValue(), 2.0), 0.5) * (1.0f - this.padding.floatValue()));
    }

    @Override
    public Float getWidth(Integer i) {
        return this.elementSize();
    }

    @Override
    public Float getHeight(Integer i) {
        return this.elementSize();
    }
}

