/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;

public class XYZColor
implements RColor {
    private Float[] channels = new Float[4];
    private boolean wasUpdated = true;
    private int hex = 0;
    public static final ColorSpace NAME = ColorSpace.XYZColor;
    public static final float REFERENCE_X = 95.047f;
    public static final float REFERENCE_Y = 100.0f;
    public static final float REFERENCE_Z = 108.883f;

    private XYZColor() {
    }

    public XYZColor(Float x, Float y, Float z) {
        this();
        this.setX(x).setY(y).setZ(z).setAlpha(Float.valueOf(100.0f));
    }

    public XYZColor(Float x, Float y, Float z, Float alpha) {
        this.setX(x).setY(y).setZ(z).setAlpha(alpha);
    }

    public XYZColor(float ... channels) {
        this();
        this.setX(Float.valueOf(channels.length >= 1 ? channels[0] : 0.0f)).setY(Float.valueOf(channels.length >= 2 ? channels[1] : 0.0f)).setZ(Float.valueOf(channels.length >= 3 ? channels[2] : 0.0f)).setAlpha(Float.valueOf(channels.length >= 4 ? channels[3] : 100.0f));
    }

    @Override
    public int getColor() {
        if (this.wasUpdated) {
            this.hex = this.toRGB().getColor();
            this.wasUpdated = false;
        }
        return this.hex;
    }

    @Override
    public XYZColor setAlpha(Float alpha) {
        this.wasUpdated = true;
        this.channels[3] = Float.valueOf(alpha.floatValue() >= 0.0f && alpha.floatValue() <= 100.0f ? alpha.floatValue() : (float)(alpha.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public XYZColor setAlpha(int alpha) {
        return this.setAlpha(Float.valueOf(alpha));
    }

    @Override
    public Float getAlpha() {
        return this.channels[3];
    }

    public XYZColor setX(Float x) {
        this.wasUpdated = true;
        this.channels[0] = Float.valueOf(x.floatValue() >= 0.0f && x.floatValue() <= 95.047f ? x.floatValue() : (x.floatValue() < 0.0f ? 0.0f : 95.047f));
        return this;
    }

    public XYZColor setX(int x) {
        return this.setX(Float.valueOf(x));
    }

    public XYZColor setY(Float y) {
        this.wasUpdated = true;
        this.channels[1] = Float.valueOf(y.floatValue() >= 0.0f && y.floatValue() <= 100.0f ? y.floatValue() : (y.floatValue() < 0.0f ? 0.0f : 100.0f));
        return this;
    }

    public XYZColor setY(int y) {
        return this.setY(Float.valueOf(y));
    }

    public XYZColor setZ(Float z) {
        this.wasUpdated = true;
        this.channels[2] = Float.valueOf(z.floatValue() >= 0.0f && z.floatValue() <= 108.883f ? z.floatValue() : (z.floatValue() < 0.0f ? 0.0f : 108.883f));
        return this;
    }

    public XYZColor setZ(int z) {
        return this.setZ(Float.valueOf(z));
    }

    public Float getX() {
        return this.channels[0];
    }

    public Float getY() {
        return this.channels[1];
    }

    public Float getZ() {
        return this.channels[2];
    }

    @Override
    public String getHexString() {
        return Integer.toHexString(this.getColor()).toUpperCase();
    }

    @Override
    public int getOpColor() {
        int hex = this.getColor();
        return 0xFF000000 | hex;
    }

    @Override
    public String getOpHexString() {
        return Integer.toHexString(this.getOpColor()).toUpperCase().substring(2);
    }

    @Override
    public float[] getValues() {
        float[] copy = new float[]{this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue()};
        return copy;
    }

    @Override
    public float[] getValuesNormalized() {
        float[] vals = this.getValues();
        vals[0] = vals[0] / 95.047f;
        vals[1] = vals[1] / 100.0f;
        vals[2] = vals[2] / 108.883f;
        vals[3] = vals[3] / 100.0f;
        return vals;
    }

    @Override
    public String getName() {
        return NAME.name();
    }

    @Override
    public ColorSpace getColorSpace() {
        return NAME;
    }

    @Override
    public XYZColor copy() {
        return new XYZColor(new Float(this.getX().floatValue()), new Float(this.getY().floatValue()), new Float(this.getZ().floatValue()), new Float(this.getAlpha().floatValue()));
    }

    @Override
    public boolean equals(RColor other) {
        if (this.getColorSpace() != other.getColorSpace()) {
            return false;
        }
        XYZColor xyzOther = (XYZColor)other;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != xyzOther.channels[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": [" + StringTools.joinAndFormat(this.getValues(), ", ", 3, 2) + "] [#" + this.getOpHexString() + "]";
    }

    public static XYZColor getMeanColor(RColor ... colors) {
        return XYZColor.getMeanColor(0, colors.length, colors);
    }

    public static XYZColor getMeanColor(ArrayList<RColor> colors) {
        return XYZColor.getMeanColor(0, colors.size(), colors);
    }

    public static XYZColor getMeanColor(int start, int end, RColor ... colors) {
        return XYZColor.getMeanColor(start, end, colors, null);
    }

    public static XYZColor getMeanColor(int start, int end, ArrayList<RColor> colors) {
        return XYZColor.getMeanColor(start, end, null, colors);
    }

    private static XYZColor getMeanColor(int start, int end, RColor[] aColors, ArrayList<RColor> lColors) {
        float[] means = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int i = start;
        while (i < end) {
            XYZColor xyz = aColors != null ? aColors[i].toXYZ() : lColors.get(i).toXYZ();
            means[0] = means[0] + xyz.getX().floatValue();
            means[1] = means[1] + xyz.getY().floatValue();
            means[2] = means[2] + xyz.getZ().floatValue();
            means[3] = means[3] + xyz.getAlpha().floatValue();
            ++i;
        }
        means[0] = means[0] / (float)(end - start);
        means[1] = means[1] / (float)(end - start);
        means[2] = means[2] / (float)(end - start);
        means[3] = means[3] / (float)(end - start);
        return new XYZColor(Float.valueOf(means[0]), Float.valueOf(means[1]), Float.valueOf(means[2]), Float.valueOf(means[3]));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return XYZColor.getLoss(rvMean, colors, null, m, 0, colors.length);
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return XYZColor.getLoss(rvMean, colors, null, m, start, end);
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m) {
        return XYZColor.getLoss(rvMean, null, lColors, m, 0, lColors.size());
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        return XYZColor.getLoss(rvMean, null, lColors, m, start, end);
    }

    private static Float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        float loss = 0.0f;
        int i = start;
        while (i < end) {
            RColor c = aColors != null ? aColors[i] : lColors.get(i);
            loss += ColorDifference.difference(rvMean, c, m).floatValue();
            ++i;
        }
        return Float.valueOf(loss / (float)(end - start));
    }

    public static XYZColor lerpColors(RColor input1, RColor input2, float amt) {
        amt = RMath.constrain(amt, 0.0f, 1.0f);
        XYZColor c1 = input1.toXYZ();
        XYZColor c2 = input2.toXYZ();
        return new XYZColor(Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getX().floatValue(), c2.getX().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getY().floatValue(), c2.getY().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getZ().floatValue(), c2.getZ().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getAlpha().floatValue(), c2.getAlpha().floatValue())));
    }

    public static XYZColor getRandomXYZ() {
        XYZColor xyz = new XYZColor(Float.valueOf(RMath.random(95.047f)), Float.valueOf(RMath.random(100.0f)), Float.valueOf(RMath.random(108.883f)));
        return xyz.toRGB().toXYZ();
    }

    @Override
    public RGBColor toRGB() {
        float r = this.channels[0].floatValue() / 100.0f * 3.2406f + this.channels[1].floatValue() / 100.0f * -1.5372f + this.channels[2].floatValue() / 100.0f * -0.4986f;
        float g = this.channels[0].floatValue() / 100.0f * -0.9689f + this.channels[1].floatValue() / 100.0f * 1.8758f + this.channels[2].floatValue() / 100.0f * 0.0415f;
        float b = this.channels[0].floatValue() / 100.0f * 0.0557f + this.channels[1].floatValue() / 100.0f * -0.204f + this.channels[2].floatValue() / 100.0f * 1.057f;
        r = (double)r > 0.0031308 ? (float)(1.055 * Math.pow(r, 0.4166666666666667) - 0.055) : (float)((double)r * 12.92);
        g = (double)g > 0.0031308 ? (float)(1.055 * Math.pow(g, 0.4166666666666667) - 0.055) : (float)((double)g * 12.92);
        b = (double)b > 0.0031308 ? (float)(1.055 * Math.pow(b, 0.4166666666666667) - 0.055) : (float)((double)b * 12.92);
        return new RGBColor(Float.valueOf(r * 255.0f), Float.valueOf(g * 255.0f), Float.valueOf(b * 255.0f), Float.valueOf(255.0f * this.getAlpha().floatValue() / 100.0f));
    }

    @Override
    public HSBColor toHSB() {
        return this.toRGB().toHSB();
    }

    @Override
    public XYZColor toXYZ() {
        return this;
    }

    @Override
    public LabColor toLab() {
        float x = this.getX().floatValue() / 95.047f;
        float y = this.getY().floatValue() / 100.0f;
        float z = this.getZ().floatValue() / 108.883f;
        Float l = Float.valueOf(903.3f * y);
        if ((double)y > 0.008856) {
            l = Float.valueOf((float)(116.0 * Math.pow(y, 0.3333333333333333) - 16.0));
        }
        x = (double)x > 0.008856 ? (float)Math.pow(x, 0.3333333333333333) : 7.787f * x + 0.13793103f;
        y = (double)y > 0.008856 ? (float)Math.pow(y, 0.3333333333333333) : 7.787f * y + 0.13793103f;
        z = (double)z > 0.008856 ? (float)Math.pow(z, 0.3333333333333333) : 7.787f * z + 0.13793103f;
        return new LabColor(l, Float.valueOf(500.0f * (x - y)), Float.valueOf(200.0f * (y - z)), this.getAlpha());
    }

    @Override
    public LCHColor toLCH() {
        return this.toLab().toLCH();
    }
}

