/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.awt.Color;
import java.util.ArrayList;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.XYZColor;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;

public class RGBColor
implements RColor {
    private Float[] channels = new Float[4];
    private boolean wasUpdated = true;
    private int hex = 0;
    public static final ColorSpace NAME = ColorSpace.RGBColor;

    private RGBColor() {
    }

    public RGBColor(Float r, Float g, Float b) {
        this();
        this.setRed(r).setGreen(g).setBlue(b).setAlpha(Float.valueOf(255.0f));
    }

    public RGBColor(Float r, Float g, Float b, Float alpha) {
        this.setRed(r).setGreen(g).setBlue(b).setAlpha(alpha);
    }

    public RGBColor(float ... channels) {
        this();
        Float a;
        Float r;
        Float g;
        Float b;
        if (channels.length == 0) {
            g = b = Float.valueOf(0.0f);
            r = b;
            a = Float.valueOf(255.0f);
        } else if (channels.length == 1) {
            g = b = Float.valueOf(channels[0]);
            r = b;
            a = Float.valueOf(255.0f);
        } else if (channels.length == 2) {
            g = b = Float.valueOf(channels[0]);
            r = b;
            a = Float.valueOf(channels[1]);
        } else if (channels.length == 3) {
            r = Float.valueOf(channels[0]);
            g = Float.valueOf(channels[1]);
            b = Float.valueOf(channels[2]);
            a = Float.valueOf(255.0f);
        } else {
            r = Float.valueOf(channels[0]);
            g = Float.valueOf(channels[1]);
            b = Float.valueOf(channels[2]);
            a = Float.valueOf(channels[3]);
        }
        this.setRed(r).setGreen(g).setBlue(b).setAlpha(a);
    }

    @Override
    public int getColor() {
        if (this.wasUpdated) {
            RGBColor rgb = this.toRGB();
            this.hex = this.channels[3].intValue() << 24 | rgb.channels[0].intValue() << 16 | rgb.channels[1].intValue() << 8 | rgb.channels[2].intValue();
            this.wasUpdated = false;
        }
        return this.hex;
    }

    @Override
    public RGBColor setAlpha(Float alpha) {
        this.wasUpdated = true;
        this.channels[3] = Float.valueOf(alpha.floatValue() >= 0.0f && alpha.floatValue() <= 255.0f ? alpha.floatValue() : (float)(alpha.floatValue() < 0.0f ? 0 : 255));
        return this;
    }

    public RGBColor setAlpha(int alpha) {
        return this.setAlpha(Float.valueOf(alpha));
    }

    @Override
    public Float getAlpha() {
        return this.channels[3];
    }

    public RGBColor setRed(Float r) {
        this.wasUpdated = true;
        this.channels[0] = Float.valueOf(r.floatValue() >= 0.0f && r.floatValue() <= 255.0f ? r.floatValue() : (float)(r.floatValue() < 0.0f ? 0 : 255));
        return this;
    }

    public RGBColor set(int hex) {
        this.channels[0] = Float.valueOf(hex >> 16 & 0xFF);
        this.channels[1] = Float.valueOf(hex >> 8 & 0xFF);
        this.channels[2] = Float.valueOf(hex & 0xFF);
        return this;
    }

    public RGBColor setRed(int r) {
        return this.setRed(Float.valueOf(r));
    }

    public RGBColor setGreen(Float g) {
        this.wasUpdated = true;
        this.channels[1] = Float.valueOf(g.floatValue() >= 0.0f && g.floatValue() <= 255.0f ? g.floatValue() : (float)(g.floatValue() < 0.0f ? 0 : 255));
        return this;
    }

    public RGBColor setGreen(int g) {
        return this.setGreen(Float.valueOf(g));
    }

    public RGBColor setBlue(Float b) {
        this.wasUpdated = true;
        this.channels[2] = Float.valueOf(b.floatValue() >= 0.0f && b.floatValue() <= 255.0f ? b.floatValue() : (float)(b.floatValue() < 0.0f ? 0 : 255));
        return this;
    }

    public RGBColor setBlue(int b) {
        return this.setBlue(Float.valueOf(b));
    }

    public Float getRed() {
        return this.channels[0];
    }

    public Float getGreen() {
        return this.channels[1];
    }

    public Float getBlue() {
        return this.channels[2];
    }

    @Override
    public String getHexString() {
        return Integer.toHexString(this.getColor()).toUpperCase();
    }

    @Override
    public int getOpColor() {
        int hex = this.getColor();
        return 0xFF000000 | hex;
    }

    @Override
    public String getOpHexString() {
        return Integer.toHexString(this.getOpColor()).toUpperCase().substring(2);
    }

    @Override
    public float[] getValues() {
        float[] copy = new float[]{this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue()};
        return copy;
    }

    @Override
    public float[] getValuesNormalized() {
        float[] vals = this.getValues();
        vals[0] = vals[0] / 255.0f;
        vals[1] = vals[1] / 255.0f;
        vals[2] = vals[2] / 255.0f;
        vals[3] = vals[3] / 255.0f;
        return vals;
    }

    @Override
    public String getName() {
        return NAME.name();
    }

    @Override
    public ColorSpace getColorSpace() {
        return NAME;
    }

    @Override
    public RGBColor copy() {
        return new RGBColor(new Float(this.getRed().floatValue()), new Float(this.getGreen().floatValue()), new Float(this.getBlue().floatValue()), new Float(this.getAlpha().floatValue()));
    }

    @Override
    public boolean equals(RColor other) {
        if (this.getColorSpace() != other.getColorSpace()) {
            return false;
        }
        RGBColor rgbOther = (RGBColor)other;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != rgbOther.channels[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": [" + StringTools.joinAndFormat(this.getValues(), ", ", 3, 2) + "] [#" + this.getOpHexString() + "]";
    }

    public static RGBColor getMeanColor(RColor ... colors) {
        return RGBColor.getMeanColor(0, colors.length, colors);
    }

    public static RGBColor getMeanColor(ArrayList<RColor> colors) {
        return RGBColor.getMeanColor(0, colors.size(), colors);
    }

    public static RGBColor getMeanColor(int start, int end, RColor ... colors) {
        return RGBColor.getMeanColor(start, end, colors, null);
    }

    public static RGBColor getMeanColor(int start, int end, ArrayList<RColor> colors) {
        return RGBColor.getMeanColor(start, end, null, colors);
    }

    private static RGBColor getMeanColor(int start, int end, RColor[] aColors, ArrayList<RColor> lColors) {
        float[] means = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int i = start;
        while (i < end) {
            RGBColor rgb = aColors != null ? aColors[i].toRGB() : lColors.get(i).toRGB();
            means[0] = means[0] + rgb.getRed().floatValue();
            means[1] = means[1] + rgb.getGreen().floatValue();
            means[2] = means[2] + rgb.getBlue().floatValue();
            means[3] = means[3] + rgb.getAlpha().floatValue();
            ++i;
        }
        means[0] = means[0] / (float)(end - start);
        means[1] = means[1] / (float)(end - start);
        means[2] = means[2] / (float)(end - start);
        means[3] = means[3] / (float)(end - start);
        return new RGBColor(Float.valueOf(means[0]), Float.valueOf(means[1]), Float.valueOf(means[2]), Float.valueOf(means[3]));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return RGBColor.getLoss(rvMean, colors, null, m, 0, colors.length);
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return RGBColor.getLoss(rvMean, colors, null, m, start, end);
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> colors, ColorDifferenceMeasure m) {
        return RGBColor.getLoss(rvMean, null, colors, m, 0, colors.size());
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> colors, ColorDifferenceMeasure m, int start, int end) {
        return RGBColor.getLoss(rvMean, null, colors, m, start, end);
    }

    private static Float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        float loss = 0.0f;
        RGBColor mean = rvMean.toRGB();
        int i = start;
        while (i < end) {
            RGBColor c;
            float diff = 0.0f;
            RGBColor rGBColor = c = aColors != null ? aColors[i].toRGB() : lColors.get(i).toRGB();
            diff = m == ColorDifferenceMeasure.RGB2R4G3B ? ColorDifference.rgbWeighted(mean, c).floatValue() : (m == ColorDifferenceMeasure.RGBMeanRed ? ColorDifference.rgbMeanRed(mean, c).floatValue() : ColorDifference.rgbEuclidean(mean, c).floatValue());
            loss += diff;
            ++i;
        }
        return Float.valueOf(loss / (float)(end - start));
    }

    public static RGBColor lerpColors(RColor input1, RColor input2, float amt) {
        amt = RMath.constrain(amt, 0.0f, 1.0f);
        RGBColor c1 = input1.toRGB();
        RGBColor c2 = input2.toRGB();
        return new RGBColor(Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getRed().floatValue(), c2.getRed().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getGreen().floatValue(), c2.getGreen().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getBlue().floatValue(), c2.getBlue().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getAlpha().floatValue(), c2.getAlpha().floatValue())));
    }

    public static RGBColor getRandomRGB() {
        return new RGBColor(Float.valueOf(RMath.random(255.0f)), Float.valueOf(RMath.random(255.0f)), Float.valueOf(RMath.random(255.0f)));
    }

    public static RGBColor toRGB(Integer hex) {
        return new RGBColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, (float)(hex & 0xFF));
    }

    public static RGBColor toRGB(Integer hex, float alpha) {
        return new RGBColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, (float)(hex & 0xFF), alpha);
    }

    public static HSBColor toHSB(float ... paramters) {
        float a;
        float r;
        float g;
        float b;
        if (paramters.length == 0) {
            b = 0.0f;
            g = 0.0f;
            r = 0.0f;
            a = 255.0f;
        } else if (paramters.length == 1) {
            g = b = paramters[0];
            r = b;
            a = 255.0f;
        } else if (paramters.length == 2) {
            g = b = paramters[0];
            r = b;
            a = paramters[1];
        } else if (paramters.length == 3) {
            r = paramters[0];
            g = paramters[1];
            b = paramters[2];
            a = 255.0f;
        } else {
            r = paramters[0];
            g = paramters[1];
            b = paramters[2];
            a = paramters[3];
        }
        float[] vals = Color.RGBtoHSB((int)r, (int)g, (int)b, null);
        return new HSBColor(Float.valueOf(vals[0] * 360.0f), Float.valueOf(vals[1] * 100.0f), Float.valueOf(vals[2] * 100.0f), Float.valueOf(100.0f * a / 255.0f));
    }

    @Override
    public RGBColor toRGB() {
        return this;
    }

    @Override
    public HSBColor toHSB() {
        return RGBColor.toHSB(this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue());
    }

    @Override
    public XYZColor toXYZ() {
        float r = this.channels[0].floatValue() / 255.0f;
        float g = this.channels[1].floatValue() / 255.0f;
        float b = this.channels[2].floatValue() / 255.0f;
        r = (double)r > 0.04045 ? (float)Math.pow(((double)r + 0.055) / 1.055, 2.4) : (float)((double)r / 12.92);
        g = (double)g > 0.04045 ? (float)Math.pow(((double)g + 0.055) / 1.055, 2.4) : (float)((double)g / 12.92);
        b = (double)b > 0.04045 ? (float)Math.pow(((double)b + 0.055) / 1.055, 2.4) : (float)((double)b / 12.92);
        return new XYZColor(Float.valueOf((r *= 100.0f) * 0.4124f + (g *= 100.0f) * 0.3576f + (b *= 100.0f) * 0.1805f), Float.valueOf(r * 0.2126f + g * 0.7152f + b * 0.0722f), Float.valueOf(r * 0.0193f + g * 0.1192f + b * 0.9505f), Float.valueOf(100.0f * this.channels[3].floatValue() / 255.0f));
    }

    @Override
    public LabColor toLab() {
        return this.toXYZ().toLab();
    }

    @Override
    public LCHColor toLCH() {
        return this.toLab().toLCH();
    }
}

