/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;

public class LabColor
implements RColor {
    private Float[] channels = new Float[4];
    private boolean wasUpdated = true;
    private int hex = 0;
    public static final ColorSpace NAME = ColorSpace.LabColor;
    public static final float MIN_L = 0.0f;
    public static final float MAX_L = 100.0f;
    public static final float MIN_A = -86.0f;
    public static final float MAX_A = 98.0f;
    public static final float MIN_B = -107.6f;
    public static final float MAX_B = 94.6f;

    private LabColor() {
    }

    public LabColor(Float l, Float a, Float b) {
        this();
        this.setLuminance(l).setA(a).setB(b).setAlpha(Float.valueOf(100.0f));
    }

    public LabColor(Float l, Float a, Float b, Float alpha) {
        this();
        this.setLuminance(l).setA(a).setB(b).setAlpha(alpha);
    }

    public LabColor(float ... channels) {
        this();
        this.setLuminance(Float.valueOf(channels.length >= 1 ? channels[0] : 0.0f)).setA(Float.valueOf(channels.length >= 2 ? channels[1] : 0.0f)).setB(Float.valueOf(channels.length >= 3 ? channels[2] : 0.0f)).setAlpha(Float.valueOf(channels.length >= 4 ? channels[3] : 100.0f));
    }

    @Override
    public int getColor() {
        if (this.wasUpdated) {
            this.hex = this.toRGB().getColor();
            this.wasUpdated = false;
        }
        return this.hex;
    }

    @Override
    public LabColor setAlpha(Float alpha) {
        this.wasUpdated = true;
        this.channels[3] = Float.valueOf(alpha.floatValue() >= 0.0f && alpha.floatValue() <= 100.0f ? alpha.floatValue() : (float)(alpha.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public LabColor setAlpha(int alpha) {
        return this.setAlpha(Float.valueOf(alpha));
    }

    @Override
    public Float getAlpha() {
        return this.channels[3];
    }

    public LabColor setLuminance(Float l) {
        this.wasUpdated = true;
        this.channels[0] = Float.valueOf(l.floatValue() >= 0.0f && l.floatValue() <= 100.0f ? l.floatValue() : (l.floatValue() < 0.0f ? 0.0f : 100.0f));
        return this;
    }

    public LabColor setLuminance(int l) {
        return this.setLuminance(Float.valueOf(l));
    }

    public LabColor setA(Float a) {
        this.wasUpdated = true;
        this.channels[1] = Float.valueOf(a.floatValue() >= -86.0f && a.floatValue() <= 98.0f ? a.floatValue() : (a.floatValue() < -86.0f ? -86.0f : 98.0f));
        return this;
    }

    public LabColor setA(int a) {
        return this.setA(Float.valueOf(a));
    }

    public LabColor setB(Float b) {
        this.wasUpdated = true;
        this.channels[2] = Float.valueOf(b.floatValue() >= -107.6f && b.floatValue() <= 94.6f ? b.floatValue() : (b.floatValue() < -107.6f ? -107.6f : 94.6f));
        return this;
    }

    public LabColor setB(int b) {
        return this.setB(Float.valueOf(b));
    }

    public float getLuminance() {
        return this.channels[0].floatValue();
    }

    public Float getA() {
        return this.channels[1];
    }

    public Float getB() {
        return this.channels[2];
    }

    public Float getChroma() {
        return Float.valueOf(LabColor.getChroma(this.getA(), this.getB()));
    }

    public Float getHue() {
        return Float.valueOf(LabColor.getHue(this.getA().floatValue(), this.getB().floatValue()));
    }

    @Override
    public String getHexString() {
        return Integer.toHexString(this.getColor()).toUpperCase();
    }

    @Override
    public int getOpColor() {
        int hex = this.getColor();
        return 0xFF000000 | hex;
    }

    @Override
    public String getOpHexString() {
        return Integer.toHexString(this.getOpColor()).toUpperCase().substring(2);
    }

    @Override
    public float[] getValues() {
        float[] copy = new float[]{this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue()};
        return copy;
    }

    @Override
    public float[] getValuesNormalized() {
        float[] vals = this.getValues();
        vals[0] = RMath.map(vals[0], 0.0f, 100.0f, 0.0f, 1.0f);
        vals[1] = RMath.map(vals[1], -86.0f, 98.0f, 0.0f, 1.0f);
        vals[2] = RMath.map(vals[2], -107.6f, 94.6f, 0.0f, 1.0f);
        vals[3] = vals[3] / 100.0f;
        return vals;
    }

    @Override
    public String getName() {
        return NAME.name();
    }

    @Override
    public ColorSpace getColorSpace() {
        return NAME;
    }

    @Override
    public LabColor copy() {
        return new LabColor(new Float(this.getLuminance()), new Float(this.getA().floatValue()), new Float(this.getB().floatValue()), new Float(this.getAlpha().floatValue()));
    }

    @Override
    public boolean equals(RColor other) {
        if (this.getColorSpace() != other.getColorSpace()) {
            return false;
        }
        LabColor labOther = (LabColor)other;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != labOther.channels[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": [" + StringTools.joinAndFormat(this.getValues(), ", ", 3, 2) + "] [#" + this.getOpHexString() + "]";
    }

    public static LabColor getMeanColor(RColor ... colors) {
        return LabColor.getMeanColor(0, colors.length, colors);
    }

    public static LabColor getMeanColor(ArrayList<RColor> colors) {
        return LabColor.getMeanColor(0, colors.size(), colors);
    }

    public static LabColor getMeanColor(int start, int end, RColor ... colors) {
        return LabColor.getMeanColor(start, end, colors, null);
    }

    public static LabColor getMeanColor(int start, int end, ArrayList<RColor> colors) {
        return LabColor.getMeanColor(start, end, null, colors);
    }

    private static LabColor getMeanColor(int start, int end, RColor[] aColors, ArrayList<RColor> lColors) {
        float[] means = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int i = start;
        while (i < end) {
            LabColor lab = aColors != null ? aColors[i].toLab() : lColors.get(i).toLab();
            means[0] = means[0] + lab.getLuminance();
            means[1] = means[1] + lab.getA().floatValue();
            means[2] = means[2] + lab.getB().floatValue();
            means[3] = means[3] + lab.getAlpha().floatValue();
            ++i;
        }
        means[0] = means[0] / (float)(end - start);
        means[1] = means[1] / (float)(end - start);
        means[2] = means[2] / (float)(end - start);
        means[3] = means[3] / (float)(end - start);
        return new LabColor(Float.valueOf(means[0]), Float.valueOf(means[1]), Float.valueOf(means[2]), Float.valueOf(means[3]));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return Float.valueOf(LabColor.getLoss(rvMean, colors, null, m, 0, colors.length));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return Float.valueOf(LabColor.getLoss(rvMean, colors, null, m, start, end));
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m) {
        return Float.valueOf(LabColor.getLoss(rvMean, null, lColors, m, 0, lColors.size()));
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        return Float.valueOf(LabColor.getLoss(rvMean, null, lColors, m, start, end));
    }

    private static float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        float loss = 0.0f;
        LabColor mean = rvMean.toLab();
        int i = start;
        while (i < end) {
            LabColor c;
            float diff = 0.0f;
            LabColor labColor = c = aColors != null ? aColors[i].toLab() : lColors.get(i).toLab();
            diff = m == ColorDifferenceMeasure.LabDeltaE1994 ? ColorDifference.labDeltaE1994(mean, c).floatValue() : (m == ColorDifferenceMeasure.LabDeltaE2000 ? ColorDifference.labDeltaE2000(mean, c).floatValue() : ColorDifference.labDeltaE(mean, c).floatValue());
            loss += diff;
            ++i;
        }
        return loss / (float)(end - start);
    }

    public static LabColor lerpColors(RColor input1, RColor input2, float amt) {
        amt = RMath.constrain(amt, 0.0f, 1.0f);
        LabColor c1 = input1.toLab();
        LabColor c2 = input2.toLab();
        return new LabColor(Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getLuminance(), c2.getLuminance())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getA().floatValue(), c2.getA().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getB().floatValue(), c2.getB().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getAlpha().floatValue(), c2.getAlpha().floatValue())));
    }

    public static LabColor getRandomLab() {
        LabColor lab = new LabColor(Float.valueOf(RMath.random(0.0f, 100.0f)), Float.valueOf(RMath.random(-86.0f, 98.0f)), Float.valueOf(RMath.random(-107.6f, 94.6f)));
        return lab.toRGB().toLab();
    }

    public static float getChroma(Float a, Float b) {
        return (float)Math.pow(Math.pow(a.floatValue(), 2.0) + Math.pow(b.floatValue(), 2.0), 0.5);
    }

    public static float getHue(double a, double b) {
        int bias = 0;
        if (a >= 0.0 && b == 0.0) {
            return 0.0f;
        }
        if (a < 0.0 && b == 0.0) {
            return 180.0f;
        }
        if (a == 0.0 && b > 0.0) {
            return 90.0f;
        }
        if (a == 0.0 && b < 0.0) {
            return 270.0f;
        }
        if (a < 0.0) {
            bias = 180;
        } else if (a > 0.0 && b < 0.0) {
            bias = 360;
        }
        return (float)((double)bias + 180.0 * Math.atan(b / a) / Math.PI);
    }

    @Override
    public RGBColor toRGB() {
        return this.toXYZ().toRGB();
    }

    @Override
    public HSBColor toHSB() {
        return this.toXYZ().toRGB().toHSB();
    }

    @Override
    public XYZColor toXYZ() {
        double y = (this.channels[0].floatValue() + 16.0f) / 116.0f;
        double x = (double)(this.channels[1].floatValue() / 500.0f) + y;
        double z = y - (double)(this.channels[2].floatValue() / 200.0f);
        y = Math.pow(y, 3.0) > 0.008856 ? Math.pow(y, 3.0) : (y - 0.13793103448275862) / 7.787;
        x = Math.pow(x, 3.0) > 0.008856 ? Math.pow(x, 3.0) : (x - 0.13793103448275862) / 7.787;
        z = Math.pow(z, 3.0) > 0.008856 ? Math.pow(z, 3.0) : (z - 0.13793103448275862) / 7.787;
        return new XYZColor(Float.valueOf((float)(x * (double)95.047f)), Float.valueOf((float)(y * 100.0)), Float.valueOf((float)(z * (double)108.883f)), this.getAlpha());
    }

    @Override
    public LabColor toLab() {
        return this;
    }

    @Override
    public LCHColor toLCH() {
        return new LCHColor(Float.valueOf(this.getLuminance()), Float.valueOf(LabColor.getChroma(this.getA(), this.getB())), Float.valueOf(LabColor.getHue(this.getA().floatValue(), this.getB().floatValue())), this.getAlpha());
    }
}

