/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;

public class LCHColor
implements RColor {
    private Float[] channels = new Float[4];
    private boolean wasUpdated = true;
    private int hex = 0;
    public static final ColorSpace NAME = ColorSpace.LCHColor;
    public static final float MAX_C = 133.45f;

    private LCHColor() {
    }

    public LCHColor(Float l, Float c, Float h) {
        this();
        this.setLuminance(l).setHue(h).setChroma(c).setAlpha(Float.valueOf(100.0f));
    }

    public LCHColor(Float l, Float c, Float h, Float alpha) {
        this();
        this.setLuminance(l).setHue(h).setChroma(c).setAlpha(alpha);
    }

    public LCHColor(float ... channels) {
        this();
        this.setLuminance(Float.valueOf(channels.length >= 1 ? channels[0] : 0.0f)).setChroma(Float.valueOf(channels.length >= 2 ? channels[1] : 0.0f)).setHue(Float.valueOf(channels.length >= 3 ? channels[2] : 0.0f)).setAlpha(Float.valueOf(channels.length >= 4 ? channels[3] : 100.0f));
    }

    @Override
    public int getColor() {
        if (this.wasUpdated) {
            this.hex = this.toRGB().getColor();
            this.wasUpdated = false;
        }
        return this.hex;
    }

    @Override
    public LCHColor setAlpha(Float alpha) {
        this.wasUpdated = true;
        this.channels[3] = Float.valueOf(alpha.floatValue() >= 0.0f && alpha.floatValue() <= 100.0f ? alpha.floatValue() : (float)(alpha.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public LCHColor setAlpha(int alpha) {
        return this.setAlpha(Float.valueOf(alpha));
    }

    @Override
    public Float getAlpha() {
        return this.channels[3];
    }

    public LCHColor setLuminance(Float l) {
        this.wasUpdated = true;
        this.channels[0] = Float.valueOf(l.floatValue() >= 0.0f && l.floatValue() <= 100.0f ? l.floatValue() : (l.floatValue() < 0.0f ? 0.0f : 100.0f));
        return this;
    }

    public LCHColor setLuminance(int l) {
        return this.setLuminance(Float.valueOf(l));
    }

    public LCHColor setHue(Float h) {
        this.wasUpdated = true;
        this.channels[2] = Float.valueOf(h.floatValue() >= 0.0f && h.floatValue() <= 360.0f ? h.floatValue() : (float)(h.floatValue() < 0.0f ? 0 : 360));
        return this;
    }

    public LCHColor setHue(int h) {
        return this.setHue(Float.valueOf(h));
    }

    public LCHColor setChroma(Float c) {
        this.wasUpdated = true;
        this.channels[1] = Float.valueOf(c.floatValue() >= 0.0f && c.floatValue() <= 133.45f ? c.floatValue() : (c.floatValue() < 0.0f ? 0.0f : 133.45f));
        return this;
    }

    public LCHColor setChroma(int c) {
        return this.setChroma(Float.valueOf(c));
    }

    public Float getLuminance() {
        return this.channels[0];
    }

    public Float getHue() {
        return this.channels[2];
    }

    public Float getChroma() {
        return this.channels[1];
    }

    @Override
    public String getHexString() {
        return Integer.toHexString(this.getColor()).toUpperCase();
    }

    @Override
    public int getOpColor() {
        int hex = this.getColor();
        return 0xFF000000 | hex;
    }

    @Override
    public String getOpHexString() {
        return Integer.toHexString(this.getOpColor()).toUpperCase().substring(2);
    }

    @Override
    public float[] getValues() {
        float[] copy = new float[]{this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue()};
        return copy;
    }

    @Override
    public float[] getValuesNormalized() {
        float[] vals = this.getValues();
        vals[0] = RMath.map(vals[0], 0.0f, 100.0f, 0.0f, 1.0f);
        vals[1] = vals[1] / 133.45f;
        vals[2] = vals[2] / 360.0f;
        vals[3] = vals[3] / 100.0f;
        return vals;
    }

    @Override
    public String getName() {
        return NAME.name();
    }

    @Override
    public ColorSpace getColorSpace() {
        return NAME;
    }

    @Override
    public LCHColor copy() {
        return new LCHColor(new Float(this.getLuminance().floatValue()), new Float(this.getChroma().floatValue()), new Float(this.getHue().floatValue()), new Float(this.getAlpha().floatValue()));
    }

    @Override
    public boolean equals(RColor other) {
        if (this.getColorSpace() != other.getColorSpace()) {
            return false;
        }
        LCHColor lchOther = (LCHColor)other;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != lchOther.channels[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": [" + StringTools.joinAndFormat(this.getValues(), ", ", 3, 2) + "] [#" + this.getOpHexString() + "]";
    }

    public static LCHColor getMeanColor(RColor ... colors) {
        return LCHColor.getMeanColor(0, colors.length, colors);
    }

    public static LCHColor getMeanColor(ArrayList<RColor> colors) {
        return LCHColor.getMeanColor(0, colors.size(), colors);
    }

    public static LCHColor getMeanColor(int start, int end, RColor ... colors) {
        return LCHColor.getMeanColor(start, end, colors, null);
    }

    public static LCHColor getMeanColor(int start, int end, ArrayList<RColor> colors) {
        return LCHColor.getMeanColor(start, end, null, colors);
    }

    private static LCHColor getMeanColor(int start, int end, RColor[] aColors, ArrayList<RColor> lColors) {
        float[] means = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int i = start;
        while (i < end) {
            LCHColor lch = aColors != null ? aColors[i].toLCH() : lColors.get(i).toLCH();
            means[0] = means[0] + lch.getLuminance().floatValue();
            means[1] = means[1] + lch.getChroma().floatValue();
            means[2] = (float)((double)means[2] + Math.cos(Math.PI * 2 * (double)lch.getHue().floatValue() / 360.0));
            means[3] = (float)((double)means[3] + Math.sin(Math.PI * 2 * (double)lch.getHue().floatValue() / 360.0));
            means[4] = means[4] + lch.getAlpha().floatValue();
            ++i;
        }
        means[0] = means[0] / (float)(end - start);
        means[1] = means[1] / (float)(end - start);
        means[2] = means[2] / (float)(end - start);
        means[3] = means[3] / (float)(end - start);
        float h = (float)(360.0 * Math.atan2(means[3], means[2]) / (Math.PI * 2));
        if (h < 0.0f) {
            h += 360.0f;
        } else if (h > 360.0f) {
            h -= 360.0f;
        }
        return new LCHColor(Float.valueOf(means[0]), Float.valueOf(means[1]), Float.valueOf(h), Float.valueOf(means[4]));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return LCHColor.getLoss(rvMean, colors, null, m, 0, colors.length);
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return LCHColor.getLoss(rvMean, colors, null, m, start, end);
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m) {
        return LCHColor.getLoss(rvMean, null, lColors, m, 0, lColors.size());
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        return LCHColor.getLoss(rvMean, null, lColors, m, start, end);
    }

    private static Float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, Integer start, Integer end) {
        float loss = 0.0f;
        RColor mean = m == ColorDifferenceMeasure.LCHCMC ? rvMean.toLab() : rvMean.toLCH();
        int i = start;
        while (i < end) {
            float diff = 0.0f;
            RColor current = aColors != null ? aColors[i] : lColors.get(i);
            RColor c = m == ColorDifferenceMeasure.LCHCMC ? current.toLab() : current.toLCH();
            diff = m == ColorDifferenceMeasure.LCHCMC ? ColorDifference.lchCMC(mean, c).floatValue() : ColorDifference.lchEuclidean(mean, c).floatValue();
            loss += diff;
            ++i;
        }
        return Float.valueOf(loss / (float)(end - start));
    }

    public static LCHColor lerpColors(RColor input1, RColor input2, float amt) {
        amt = RMath.constrain(amt, 0.0f, 1.0f);
        LCHColor c1 = input1.toLCH();
        LCHColor c2 = input2.toLCH();
        float minH = RMath.min(c1.getHue().floatValue(), c2.getHue().floatValue());
        float maxH = RMath.min(c1.getHue().floatValue(), c2.getHue().floatValue());
        float h1 = c1.getHue().floatValue();
        float h2 = c2.getHue().floatValue();
        float h = 0.0f;
        if (maxH - minH > 180.0f) {
            h1 = h1 == minH ? (h1 += 360.0f) : (h1 -= 360.0f);
        }
        if ((h = h2 - h1 == 0.0f ? h2 : RMath.map(amt, 0.0f, 1.0f, h1, h2)) < 0.0f) {
            h += 360.0f;
        } else if (h > 360.0f) {
            h -= 360.0f;
        }
        return new LCHColor(Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getLuminance().floatValue(), c2.getLuminance().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getChroma().floatValue(), c2.getChroma().floatValue())), Float.valueOf(h), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getAlpha().floatValue(), c2.getAlpha().floatValue())));
    }

    public static LCHColor getRandomLCH() {
        LCHColor lch = new LCHColor(Float.valueOf(RMath.random(0.0f, 100.0f)), Float.valueOf(RMath.random(133.45f)), Float.valueOf(RMath.random(360.0f)));
        return lch.toRGB().toLCH();
    }

    @Override
    public RGBColor toRGB() {
        return this.toLab().toRGB();
    }

    @Override
    public HSBColor toHSB() {
        return this.toRGB().toHSB();
    }

    @Override
    public XYZColor toXYZ() {
        return this.toLab().toXYZ();
    }

    @Override
    public LabColor toLab() {
        return new LabColor(this.channels[0], Float.valueOf((float)Math.cos(Math.PI * 2 * (double)this.channels[2].floatValue() / 360.0) * this.channels[1].floatValue()), Float.valueOf((float)Math.sin(Math.PI * 2 * (double)this.channels[2].floatValue() / 360.0) * this.channels[1].floatValue()), this.getAlpha());
    }

    @Override
    public LCHColor toLCH() {
        return this;
    }
}

