/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.awt.Color;
import java.util.ArrayList;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;

public class HSBColor
implements RColor {
    private Float[] channels = new Float[4];
    private boolean wasUpdated = true;
    private int hex = 0;
    public static final ColorSpace NAME = ColorSpace.HSBColor;

    private HSBColor() {
    }

    public HSBColor(Float h, Float s, Float b) {
        this();
        this.setHue(h).setSaturation(s).setBrightness(b).setAlpha(Float.valueOf(100.0f));
    }

    public HSBColor(Float h, Float s, Float b, Float alpha) {
        this();
        this.setHue(h).setSaturation(s).setBrightness(b).setAlpha(alpha);
    }

    public HSBColor(float ... channels) {
        this();
        this.setHue(Float.valueOf(channels.length >= 1 ? channels[0] : 0.0f)).setSaturation(Float.valueOf(channels.length >= 2 ? channels[1] : 0.0f)).setBrightness(Float.valueOf(channels.length >= 3 ? channels[2] : 0.0f)).setAlpha(Float.valueOf(channels.length >= 4 ? channels[3] : 100.0f));
    }

    @Override
    public int getColor() {
        if (this.wasUpdated) {
            this.hex = this.toRGB().getColor();
            this.wasUpdated = false;
        }
        return this.hex;
    }

    @Override
    public HSBColor setAlpha(Float alpha) {
        this.wasUpdated = true;
        this.channels[3] = Float.valueOf(alpha.floatValue() >= 0.0f && alpha.floatValue() <= 100.0f ? alpha.floatValue() : (float)(alpha.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public HSBColor setAlpha(int alpha) {
        return this.setAlpha(Float.valueOf(alpha));
    }

    @Override
    public Float getAlpha() {
        return this.channels[3];
    }

    public HSBColor setHue(int h) {
        return this.setHue(Float.valueOf(h));
    }

    public HSBColor setHue(Float h) {
        this.wasUpdated = true;
        this.channels[0] = Float.valueOf(h.floatValue() >= 0.0f && h.floatValue() <= 360.0f ? h.floatValue() : (float)(h.floatValue() < 0.0f ? 0 : 360));
        return this;
    }

    public HSBColor setSaturation(int s) {
        return this.setSaturation(Float.valueOf(s));
    }

    public HSBColor setSaturation(Float s) {
        this.wasUpdated = true;
        this.channels[1] = Float.valueOf(s.floatValue() >= 0.0f && s.floatValue() <= 100.0f ? s.floatValue() : (float)(s.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public HSBColor setBrightness(int b) {
        return this.setBrightness(Float.valueOf(b));
    }

    public HSBColor setBrightness(Float b) {
        this.wasUpdated = true;
        this.channels[2] = Float.valueOf(b.floatValue() >= 0.0f && b.floatValue() <= 100.0f ? b.floatValue() : (float)(b.floatValue() < 0.0f ? 0 : 100));
        return this;
    }

    public Float getHue() {
        return this.channels[0];
    }

    public Float getSaturation() {
        return this.channels[1];
    }

    public Float getBrightness() {
        return this.channels[2];
    }

    @Override
    public String getHexString() {
        return Integer.toHexString(this.getColor()).toUpperCase();
    }

    @Override
    public int getOpColor() {
        int hex = this.getColor();
        return 0xFF000000 | hex;
    }

    @Override
    public String getOpHexString() {
        return Integer.toHexString(this.getOpColor()).toUpperCase().substring(2);
    }

    @Override
    public String getName() {
        return NAME.name();
    }

    @Override
    public ColorSpace getColorSpace() {
        return NAME;
    }

    @Override
    public float[] getValues() {
        float[] copy = new float[]{this.channels[0].floatValue(), this.channels[1].floatValue(), this.channels[2].floatValue(), this.channels[3].floatValue()};
        return copy;
    }

    @Override
    public float[] getValuesNormalized() {
        float[] vals = this.getValues();
        vals[0] = vals[0] / 360.0f;
        vals[1] = vals[1] / 100.0f;
        vals[2] = vals[2] / 100.0f;
        vals[3] = vals[3] / 100.0f;
        return vals;
    }

    @Override
    public HSBColor copy() {
        return new HSBColor(new Float(this.getHue().floatValue()), new Float(this.getSaturation().floatValue()), new Float(this.getBrightness().floatValue()), new Float(this.getAlpha().floatValue()));
    }

    @Override
    public boolean equals(RColor other) {
        if (this.getColorSpace() != other.getColorSpace()) {
            return false;
        }
        HSBColor hsbOther = (HSBColor)other;
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] != hsbOther.channels[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": [" + StringTools.joinAndFormat(this.getValues(), ", ", 3, 2) + "] [#" + this.getOpHexString() + "]";
    }

    public static HSBColor getMeanColor(RColor ... colors) {
        return HSBColor.getMeanColor(0, colors.length, colors);
    }

    public static HSBColor getMeanColor(ArrayList<RColor> colors) {
        return HSBColor.getMeanColor(0, colors.size(), colors);
    }

    public static HSBColor getMeanColor(int start, int end, RColor ... colors) {
        return HSBColor.getMeanColor(start, end, colors, null);
    }

    public static HSBColor getMeanColor(int start, int end, ArrayList<RColor> colors) {
        return HSBColor.getMeanColor(start, end, null, colors);
    }

    private static HSBColor getMeanColor(int start, int end, RColor[] aColors, ArrayList<RColor> lColors) {
        float[] means = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int i = start;
        while (i < end) {
            HSBColor hsb = aColors != null ? aColors[i].toHSB() : lColors.get(i).toHSB();
            means[0] = (float)((double)means[0] + Math.cos(Math.PI * 2 * (double)hsb.getHue().floatValue() / 360.0));
            means[1] = (float)((double)means[1] + Math.sin(Math.PI * 2 * (double)hsb.getHue().floatValue() / 360.0));
            means[2] = means[2] + hsb.getSaturation().floatValue();
            means[3] = means[3] + hsb.getBrightness().floatValue();
            means[4] = means[4] + hsb.getAlpha().floatValue();
            ++i;
        }
        means[0] = means[0] / (float)(end - start);
        means[1] = means[1] / (float)(end - start);
        means[2] = means[2] / (float)(end - start);
        means[3] = means[3] / (float)(end - start);
        means[4] = means[4] / (float)(end - start);
        float h = (float)(360.0 * Math.atan2(means[1], means[0]) / (Math.PI * 2));
        if (h < 0.0f) {
            h += 360.0f;
        } else if (h > 360.0f) {
            h -= 360.0f;
        }
        return new HSBColor(Float.valueOf(h), Float.valueOf(means[2]), Float.valueOf(means[3]), Float.valueOf(means[4]));
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return HSBColor.getLoss(rvMean, colors, null, m, 0, colors.length);
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return HSBColor.getLoss(rvMean, colors, null, m, start, end);
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m) {
        return HSBColor.getLoss(rvMean, null, lColors, m, 0, lColors.size());
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        return HSBColor.getLoss(rvMean, null, lColors, m, start, end);
    }

    private static Float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        float loss = 0.0f;
        HSBColor mean = rvMean.toHSB();
        int i = start;
        while (i < end) {
            HSBColor c;
            float diff = 0.0f;
            HSBColor hSBColor = c = aColors != null ? aColors[i].toHSB() : lColors.get(i).toHSB();
            diff = m == ColorDifferenceMeasure.HSBCone ? ColorDifference.hsbCone(mean, c).floatValue() : (m == ColorDifferenceMeasure.HSBCylinder ? ColorDifference.hsbCylinder(mean, c).floatValue() : ColorDifference.hsbEuclidean(mean, c).floatValue());
            loss += diff;
            ++i;
        }
        return Float.valueOf(loss / (float)(end - start));
    }

    public static HSBColor lerpColors(RColor input1, RColor input2, float amt) {
        amt = RMath.constrain(amt, 0.0f, 1.0f);
        HSBColor c1 = input1.toHSB();
        HSBColor c2 = input2.toHSB();
        float minH = RMath.min(c1.getHue().floatValue(), c2.getHue().floatValue());
        float maxH = RMath.min(c1.getHue().floatValue(), c2.getHue().floatValue());
        float h1 = c1.getHue().floatValue();
        float h2 = c2.getHue().floatValue();
        float h = 0.0f;
        if (maxH - minH > 180.0f) {
            h1 = h1 == minH ? (h1 += 360.0f) : (h1 -= 360.0f);
        }
        if ((h = h2 - h1 == 0.0f ? h2 : RMath.map(amt, 0.0f, 1.0f, h1, h2)) < 0.0f) {
            h += 360.0f;
        } else if (h > 360.0f) {
            h -= 360.0f;
        }
        return new HSBColor(Float.valueOf(h), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getSaturation().floatValue(), c2.getSaturation().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getBrightness().floatValue(), c2.getBrightness().floatValue())), Float.valueOf(RMath.map(amt, 0.0f, 1.0f, c1.getAlpha().floatValue(), c2.getAlpha().floatValue())));
    }

    public static HSBColor getRandomHSB() {
        return new HSBColor(Float.valueOf(RMath.random(360.0f)), Float.valueOf(RMath.random(100.0f)), Float.valueOf(RMath.random(100.0f)));
    }

    public static HSBColor toHSB(int hex) {
        return RGBColor.toHSB(new Float(hex >> 16 & 0xFF).floatValue(), new Float(hex >> 8 & 0xFF).floatValue(), new Float(hex & 0xFF).floatValue(), 255.0f);
    }

    public static HSBColor toHSB(int hex, float alpha) {
        return RGBColor.toHSB(new Float(hex >> 16 & 0xFF).floatValue(), new Float(hex >> 8 & 0xFF).floatValue(), new Float(hex & 0xFF).floatValue(), alpha);
    }

    @Override
    public RGBColor toRGB() {
        int hex = Color.HSBtoRGB(this.channels[0].floatValue() / 360.0f, this.channels[1].floatValue() / 100.0f, this.channels[2].floatValue() / 100.0f);
        return RGBColor.toRGB(hex, 255.0f * this.getAlpha().floatValue() / 100.0f);
    }

    @Override
    public HSBColor toHSB() {
        return this;
    }

    @Override
    public XYZColor toXYZ() {
        return this.toRGB().toXYZ();
    }

    @Override
    public LabColor toLab() {
        return this.toRGB().toLab();
    }

    @Override
    public LCHColor toLCH() {
        return this.toRGB().toLCH();
    }
}

