/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import net.returnvoid.color.ColorDifferenceMeasure;

public enum ColorSpace {
    RGBColor,
    XYZColor,
    LabColor,
    HSBColor,
    LCHColor;


    public ColorDifferenceMeasure toColorDifferenceMeasure() {
        if (this == RGBColor) {
            return ColorDifferenceMeasure.RGBEuclidean;
        }
        if (this == HSBColor) {
            return ColorDifferenceMeasure.HSBEuclidean;
        }
        if (this == LabColor) {
            return ColorDifferenceMeasure.LabDeltaE;
        }
        if (this == LCHColor) {
            return ColorDifferenceMeasure.LCHEuclidean;
        }
        return ColorDifferenceMeasure.XYZEuclidean;
    }

    public boolean equals(ColorDifferenceMeasure m) {
        ColorSpace other = m.toColorSpace();
        return this.name().equals(other.name());
    }
}

